/*
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of "Eclipse Public License v1.0"
 * which accompanies this distribution, and is available
 * at the URL "http://www.eclipse.org/legal/epl-v10.html".
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description: manages scrollable portion of view.
 *
 */

#ifndef MSGUNIEDITORSCROLLAREA_H_
#define MSGUNIEDITORSCROLLAREA_H_

#include <HbScrollArea>
#include "convergedmessageaddress.h"

class QGraphicsLinearLayout;
class MsgUnifiedEditorAddress;
class MsgUnifiedEditorSubject;
class MsgUnifiedEditorBody;
class MsgUnifiedEditorBaseWidget;
class ConvergedMessage;
class MsgAttachmentContainer;
class MsgUnifiedEditorMonitor;

class MsgUnifiedEditorScrollArea : public HbScrollArea
{
    Q_OBJECT
    
public:
    MsgUnifiedEditorScrollArea(MsgUnifiedEditorMonitor* msgMonitor,QGraphicsItem *parent = 0);
    ~MsgUnifiedEditorScrollArea();
    
    /**
     * Tells if contacts in "To" "Cc" , "Bcc" field are valid or not
     */
    bool contactsValid();

    /**
     * First address of "To" field.
     */
    ConvergedMessageAddress* currentAddress();
    
    /**
     * Packs the content inside editor into converged message
     * @param [OUT]msg, converged message to hold editor data
     * @param isSave, flag to indicate that msg needs to be packed
     * for saving to draft or not
     * @return returns error if something fails
     */
    int packMessage(ConvergedMessage &msg, bool isSave);
    
    /**
     * add attachments to the editor
     * @param files list of file paths
     */
    void addAttachments(const QStringList files);
    
    /**
     * Checks if vcf file name is already in use or not.
     */
    bool fileNameInUse(const QString& fileName);
    
    /**
     * Enables/Disables scrolling based on parameter passed.
     */
    void enableScrolling(bool enable);
    
    /**
     * Populate data into various fields from ConvergedMessage.
     * @param msg, ConvergedMessage object.
     * @param draftMessage, true if message is opened from drafts.
     */
    void populateContent(const ConvergedMessage& msg, bool draftMessage, bool checkForInline);
    
protected:
    /**
     * Reimplemented from base class.
     */
    virtual bool scrollByAmount(const QPointF &delta);
    

    
private:
    void init();
    void setFocus(MsgUnifiedEditorBaseWidget* item);
    void formatAddresses(ConvergedMessageAddressList& addresses);
    
signals:
    //emitted to enable or disable attach submenu options.
    void enableMenuAction(int action, bool enable);
    
public slots:

    /**
     * Posts event to launch key pad.
     */
    void postInputPanelEvent();
    
    /**
     * slot to add Cc,Bcc field.
     */
    void addCcBcc(bool needFocus = false);
    
    /**
     * slot to add subject field.
     */
    void addSubject(bool needFocus = false);
    
    /**
     * slot to change priority.
     */
    void changePriority();
    
    void setImage(const QString& path, bool draftMessage = false);
    
    void setAudio(const QString& filePath);
    
private slots:

    /**
     * slot to handle Cc, Bcc group-box's toggle action
     */
    void updateOtherRecipientCount(bool state);
    
    /**
     * slot to tell view to remove the attachment's container
     */
    void removeAttachmentContainer();

    /**
     * add an attachment to the editor
     * @return addition operation status
     */
    int addAttachment(const QString& filepath);


private:

    MsgUnifiedEditorMonitor* mMsgMonitor;
    QGraphicsLinearLayout* mMainLayout;
    MsgUnifiedEditorAddress* mToField;
    MsgUnifiedEditorAddress* mCcField;
    MsgUnifiedEditorAddress* mBccField;
    MsgUnifiedEditorSubject* mSubjectField;
    MsgUnifiedEditorBody* mBody;    
    MsgAttachmentContainer* mAttachmentContainer;
    
    bool mEnableScrolling;
#ifdef UNIEDITOR_UNIT_TEST
    friend class TestMsgUnifiedEditorScrollArea;
#endif
};

#endif /* MSGUNIEDITORSCROLLAREA_H_ */
