/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   ?Description
*
*/

//include
#include <hbmainwindow.h>
#include <hbinstance.h>
#include <EIKENV.H>
#include <QSymbianEvent>

//userinclude
#include "msgapplication.h"
#include "debugtraces.h"

MsgApplication::MsgApplication( int &argc, char *argv[] )
    : HbApplication( argc, argv)
	{
	
	}

MsgApplication::~MsgApplication()
	{
	
	}

void MsgApplication::initViewReady()
	{	
	HbMainWindow *window = hbInstance->allMainWindows().first();
	connect(window, SIGNAL(viewReady()),this,SLOT(handleAppReady()));
	}

void MsgApplication::handleAppReady()
	{
	QDEBUG_WRITE("MsgApplication::handleAppReady:applicationReady signal is emited")
	emit applicationReady();
	HbMainWindow *window = hbInstance->allMainWindows().first();
	disconnect(window, SIGNAL(viewReady()),this,SLOT(handleAppReady()));
	}

/*
 * Overloaded method
 * handles S60 events
 */
bool MsgApplication::symbianEventFilter(const QSymbianEvent *event)
{
    QSymbianEvent::Type eventType = event->type();
    
    // handle close event
    if (eventType == QSymbianEvent::CommandEvent && 
            event->command() == EEikCmdExit) {
        emit closeEvent();
        return true;
    }
    return false;
}

