/*
* Copyright (c) 2005 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  
*
*/


#ifndef MUSUIRECEIVECONTROLLER_H
#define MUSUIRECEIVECONTROLLER_H

#include "musuieventcontroller.h"
#include "musengreceivesessionobserver.h"
#include "musengmcesession.h"
#include "musuiinvitationqueryobserver.h"
#include "musunittesting.h"
#include "musuiactivetimerobserver.h"

#include <e32base.h>

class MMusUiReceiveObserver;
class CMusEngReceiveSession;
class MMusUiReceiveObserver;
class CMusUiActiveTimer;

/**
 *
 *
 * @lib musui.exe
 */
class CMusUiReceiveController : public CMusUiEventController,
                                public MMusEngReceiveSessionObserver,
                                public MMusUiInvitationQueryObserver,
                                public MMusUiActiveTimerObserver
    {

public:

    /**
     * Two-phased constructor. Leaves on failure.
     * @return The constructed CMusUiReceiveController object.
     */
	static CMusUiReceiveController* NewL(
	                        MMusUiEventObserver& aEventObserver,
                            MMusUiSharingObserver& aSharingObserver,
	                        MMusUiReceiveObserver& aReceiveObserver,
	                        const TRect& aRect );

    /**
     * Destructor.
     */
	virtual ~CMusUiReceiveController();

private:

    /**
     * C++ constructor.
     */
	CMusUiReceiveController( MMusUiEventObserver& aEventObserver,
	                         MMusUiSharingObserver& aSharingObserver,
	                         MMusUiReceiveObserver& aReceiveObserver );
	
    /**
     * Symbian 2nd-phase constructor.
     * @leave One of the system wide error codes
     * @param aRect Original view's rectangle, which is centered and passed
     *        for the Engine.
     */
	void ConstructL( const TRect& aRect );
	

public:	// new functions:
    
    /**
     * Gets called by MMusEngReceiveSessionObserver's Incoming Session.
     * Function cancels the timer and displays the invitation query dialog.
     * MO Address is saved into memeber variable iOriginator.
     * @leave One of the system wide error codes
     * @param aOriginator The Address of MO.
     * @param aOriginatorIdentity The identity of MO.     
     */
    void HandleIncomingSessionL( const TDesC& aOriginator,
                                 const TDesC& iOriginatorIdentity );
                                  
    TBool ClipMutedL();
    
    TBool ClipContainsAudioL();
    
    /** 
     * Determines whether video is being played in full screen mode. 
     */
    TBool FullScreenSelected();
    
    
public: // from CMusUiEventController
    
    /**
    * Returns a pointer to engine side session.
    */
    virtual CMusEngMceSession* EngineSession();

    /**
     * Implementation of the pure virtual function in MMusUiCallbackObserver.
     * Handled async. event in the MT is EMusUiAsyncInviteAccepted.
     * @param aEventId Async. event
     */
    virtual void HandleAsyncEventL( TMusUiAsyncEvent aEventId );
    
    /**
     * Implementation of the pure virtual function from CMusUiEventController
     * @return iOriginator, the address of MO
     */
    virtual const TDesC& TypedAddress() const;

    /**
    * Updates softkeys specific to receiving. Delegates other requests to
    * a base class.
    */
    // virtual void UpdateSoftkeyL( TInt aToolbarItem );
    
    /**
     * Handles commands generated by UI's Toolbar in the Receive View.
     * @pre iSession != NULL
     * @leave One of the system wide error codes
     * @param aCommand Identiefier of the event's command.
     */
    virtual void OfferToolbarEventL( TInt aCommand );
    
    virtual void HandleCommandL( TInt aCommand );

    /**
     * Implementation of the pure virtual function from CMusUiEventController
     * Deletes the Engine instance.
     */
    virtual void DeleteEngineSession();


public: // from MMusEngReceiveSessionObserver

    /**
     * Called by engine when timer can be cancelled.
     */
    virtual void IncomingSessionPreNotification();

    /**
     * Called by the engine, when session is incoming.
     * @param aOriginator The address of MO.
     * @param aOriginatorIdentity The identity of MO.
     */
    virtual void IncomingSession( const TDesC& aOriginator, 
                                  const TDesC& iOriginatorIdentity );

    /**
     * Called by the engine, when current receiving session is buffering
     * received RTP.
     */
    virtual void StreamBuffering();
    

public:	// from MMusEngSessionObserver

    /**
     * Called by the engine, when incoming session is established.
     * Dismisses the wait dialog and sets up the status pane
     */
    void SessionEstablished();

    /**
     * Called by the engine, when session has been terminated.
     * If connection is not established, dismisses the invitation query dialog,
     * shows an error dialog and exits.
     * Otherwise dismisses wait dialog and exits.
     */
	void SessionTerminated();

    /**
     * Called by the engine, when current session has lost network connection.
     * Displays an error dialog.
     */
    void SessionConnectionLost();
    
    /**
     * Called by the engine, when an undefined exception has occurred.
     * Dismisses the wait dialog.
     */
    void SessionFailed();
    
    /**
     * Called by the engine, when we are not sending or receiving RTP.
     * Updates the icon to be Pause icon.
     */
	void StreamIdle();
	
    /**
     * Called by the engine, when current session state is changed to streaming
     * Dismisses the wait dialog, and updates the icon to Play icon.
     */
	void StreamStreaming();	

    /**
     * Called by the engine, when time information of the session 
     * should be updated.
     * Calls Observer's UpdateSessionTime() function.
     * @param aSeconds Session time in secods to be formatted.
     */
	void SessionTimeChanged( const TTimeIntervalSeconds& aSeconds );
	
    /**
     * Called by the engine, when RTCP inactivity timeout has occurred.
     * Exits the application.
     */
    void InactivityTimeout();
    
	
public: // from MMusUiInvitationQueryObserver

    /**
     * Called if the user accepts the incoming invitation.
     * Calls Engine's AcceptInvitationL() function with ETrue and starts
     * to show the wait dialog async.
     * @pre iSession != NULL
     * @leave One of the system wide error codes
     */
    void InvitationAcceptedL();
    
    /*
     * Called if the user rejects the incoming invitation.
     * Calls Engine's AcceptInvitationL() with EFalse and exits the application.
     * @pre iSession != NULL
     * @leave One of the system wide error codes
     */
    void InvitationRejectedL();

public: // from MMusUiActiveTimerObserver
	
    /*
     * Called if the timer completes.
     * Calls ShutdownL() function.
     */
	void TimerComplete( CMusUiActiveTimer* aTimer );


protected: // from CMusUiEventController

    /**
    * Receive specific functionality of exit procedure
    */
    virtual void ExitProcedureL( TBool aUserAcceptance );
    

private:	// new functions:
    /**
     * Changes video playing mode to the opposite. 
     * Value of iFullScreenSelected will be changed to opposite as well.
     */
    void ChangeFullScreenModeL(); 

    
    /**
     * Displays the wait dialog calling Observer's ShowWaitDialogL with a string
     * loaded from resources.
     * @leave One of the system wide error codes
     */
    void ShowWaitDialogL();
    
    /**
    * 
    */
    void SessionEstablishedL();
    
    
private:

    /**
     * Observer interface for receiving specific callbacks
     */
	MMusUiReceiveObserver& iReceiveObserver;
	
    /**
     * The engine object for MT
     */
	CMusEngReceiveSession* iSession;
	
    /**
     * Address of the MO
     */
	HBufC* iOriginator;

    /**
     * Flag indicating that video is being played in Full Screen mode
     */
    TBool iFullScreenSelected;
    /**
     * Active object timer instance
     */
	CMusUiActiveTimer* iTimer;
	
	CMusEngMceSession::TDisplayOrientation iOriginalMceOrientation;
	
	/**
	 * Flag indicating that the stream is paused
	 */
	TBool iStreamPaused;
	
	
    MUS_UNITTEST( UT_CMusUiReceiveController; )

    };

#endif // MUSUIRECEIVECONTROLLER_H

// end of file
