/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.html;

import com.google.common.collect.Lists;
import com.google.jstestdriver.html.HtmlDocParser;
import com.google.jstestdriver.token.BufferedTokenStream;
import com.google.jstestdriver.token.ConcreteToken;
import com.google.jstestdriver.token.Node;
import com.google.jstestdriver.token.Nodes;
import com.google.jstestdriver.token.Token;
import java.util.LinkedList;
import java.util.List;

public class HtmlDocNodeFactory
implements HtmlDocParser.NodeFactory {
    private static final Token DOC_START = ConcreteToken.from("/*:DOC");
    private static final Token EQUALS = ConcreteToken.from("=");
    private static final Token END_COMMENT = ConcreteToken.from("*/");
    private final CreateNodeStrategy createStrategy;

    public HtmlDocNodeFactory(CreateNodeStrategy createNodeStrategy) {
        this.createStrategy = createNodeStrategy;
    }

    public void create(BufferedTokenStream bufferedTokenStream, Nodes nodes) {
        Token token;
        Token token2 = null;
        LinkedList<Token> linkedList = Lists.newLinkedList();
        if (!DOC_START.equals(bufferedTokenStream.read())) {
            bufferedTokenStream.reset();
            return;
        }
        token2 = bufferedTokenStream.read();
        if (!EQUALS.equals(bufferedTokenStream.read())) {
            bufferedTokenStream.reset();
            return;
        }
        while (bufferedTokenStream.available() && !END_COMMENT.equals(token = bufferedTokenStream.read())) {
            linkedList.add(token);
        }
        bufferedTokenStream.mark();
        nodes.add(this.createStrategy.create(token2, linkedList));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CreateNodeStrategy {
        public Node create(Token var1, List<Token> var2);
    }
}

