/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonArrayDeserializationVisitor;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObjectDeserializationVisitor;
import com.google.gson.ObjectConstructor;
import com.google.gson.ObjectNavigator;
import com.google.gson.ObjectNavigatorFactory;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.Preconditions;
import java.lang.reflect.Type;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JsonDeserializationVisitor<T>
implements ObjectNavigator.Visitor {
    protected static Logger logger = Logger.getLogger(JsonDeserializationVisitor.class.getName());
    protected final ObjectNavigatorFactory factory;
    protected final ObjectConstructor objectConstructor;
    protected final ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers;
    protected T target;
    protected final JsonElement json;
    protected final Type targetType;
    protected final JsonDeserializationContext context;

    public JsonDeserializationVisitor(JsonElement json, Type targetType, ObjectNavigatorFactory factory, ObjectConstructor objectConstructor, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers, JsonDeserializationContext context) {
        Preconditions.checkNotNull(json);
        this.targetType = targetType;
        this.factory = factory;
        this.objectConstructor = objectConstructor;
        this.deserializers = deserializers;
        this.json = json;
        this.context = context;
    }

    T getTarget() {
        if (this.target == null) {
            this.target = this.constructTarget();
        }
        return this.target;
    }

    protected abstract T constructTarget();

    @Override
    public final boolean visitUsingCustomHandler(Object obj, Type objType) {
        JsonDeserializer<?> deserializer = this.deserializers.getHandlerFor(objType);
        if (deserializer != null) {
            this.target = deserializer.deserialize(this.json, objType, this.context);
            return true;
        }
        return false;
    }

    final Object visitChildAsObject(Type childType, JsonElement jsonChild) {
        JsonObjectDeserializationVisitor childVisitor = new JsonObjectDeserializationVisitor(jsonChild, childType, this.factory, this.objectConstructor, this.deserializers, this.context);
        return this.visitChild(childType, childVisitor);
    }

    final Object visitChildAsArray(Type childType, JsonArray jsonChild) {
        JsonArrayDeserializationVisitor childVisitor = new JsonArrayDeserializationVisitor(jsonChild.getAsJsonArray(), childType, this.factory, this.objectConstructor, this.deserializers, this.context);
        return this.visitChild(childType, childVisitor);
    }

    private Object visitChild(Type type, JsonDeserializationVisitor<?> childVisitor) {
        Object child = childVisitor.getTarget();
        ObjectNavigator on = this.factory.create(child, type);
        on.accept(childVisitor);
        return childVisitor.getTarget();
    }
}

