/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.Command;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.Time;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.joda.time.Instant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveBrowser {
    private static final long TIMEOUT = 15000L;
    private static final int POLL_RESPONSE_TIMEOUT = 2;
    private final Time time;
    private final String id;
    private final BrowserInfo browserInfo;
    private final BlockingQueue<Command> commandsToRun = new LinkedBlockingQueue<Command>();
    private long timeout = 10L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private Instant lastHeartBeat;
    private Set<FileInfo> fileSet = new LinkedHashSet<FileInfo>();
    private final BlockingQueue<CommandResponse> responses = new LinkedBlockingQueue<CommandResponse>();
    private Command commandRunning = null;
    private Command lastCommandDequeued;

    public SlaveBrowser(Time time, String string, BrowserInfo browserInfo) {
        this.time = time;
        this.lastHeartBeat = time.now();
        this.id = string;
        this.browserInfo = browserInfo;
    }

    public String getId() {
        return this.id;
    }

    public void createCommand(String string) {
        try {
            this.commandsToRun.put(new Command(string));
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public synchronized Command dequeueCommand() {
        try {
            Command command = this.commandsToRun.poll(this.timeout, this.timeUnit);
            if (command != null) {
                this.commandRunning = command;
                this.lastCommandDequeued = command;
            }
            return command;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public Command getLastDequeuedCommand() {
        return this.lastCommandDequeued;
    }

    public BrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    public void setDequeueTimeout(long l, TimeUnit timeUnit) {
        this.timeout = l;
        this.timeUnit = timeUnit;
    }

    public void heartBeat() {
        this.lastHeartBeat = this.time.now();
    }

    public Instant getLastHeartBeat() {
        return this.lastHeartBeat;
    }

    public void addFiles(Collection<FileInfo> collection) {
        this.fileSet.removeAll(collection);
        this.fileSet.addAll(collection);
    }

    public Set<FileInfo> getFileSet() {
        return this.fileSet;
    }

    public void resetFileSet() {
        this.fileSet.clear();
    }

    public CommandResponse getResponse() {
        try {
            return this.responses.poll(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public void addResponse(String string, boolean bl) {
        if (bl) {
            this.commandRunning = null;
        }
        this.responses.offer(new CommandResponse(string, bl));
    }

    public void clearResponseQueue() {
        this.responses.clear();
    }

    public boolean isCommandRunning() {
        return this.commandRunning != null;
    }

    public synchronized Command getCommandRunning() {
        return this.commandRunning;
    }

    public void removeFiles(Collection<FileSource> collection) {
        LinkedHashSet<FileInfo> linkedHashSet = new LinkedHashSet<FileInfo>();
        block0: for (FileSource fileSource : collection) {
            for (FileInfo fileInfo : this.fileSet) {
                if (!fileInfo.getFileName().equals(fileSource.getBasePath())) continue;
                linkedHashSet.add(fileInfo);
                continue block0;
            }
        }
        this.fileSet.removeAll(linkedHashSet);
    }

    public Command peekCommand() {
        return (Command)this.commandsToRun.peek();
    }

    public void clearCommandRunning() {
        if (this.commandRunning != null) {
            this.commandRunning = null;
            this.commandsToRun.clear();
            this.responses.clear();
        }
    }

    public boolean isAlive() {
        return this.time.now().getMillis() - this.lastHeartBeat.getMillis() < 15000L;
    }

    public String toString() {
        return "SlaveBrowser(browserInfo=" + this.browserInfo + ", id=" + this.id + ")";
    }

    public static class CommandResponse {
        private String response;
        private final boolean last;

        public CommandResponse(String string, boolean bl) {
            this.response = string;
            this.last = bl;
        }

        public String getResponse() {
            return this.response;
        }

        public boolean isLast() {
            return this.last;
        }

        public void setResponse(String string) {
            this.response = string;
        }
    }
}

