/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializationVisitor;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.ObjectConstructor;
import com.google.gson.ObjectNavigatorFactory;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.TypeInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JsonObjectDeserializationVisitor<T>
extends JsonDeserializationVisitor<T> {
    JsonObjectDeserializationVisitor(JsonElement json, Type type, ObjectNavigatorFactory factory, ObjectConstructor objectConstructor, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers, JsonDeserializationContext context) {
        super(json, type, factory, objectConstructor, deserializers, context);
    }

    @Override
    protected T constructTarget() {
        return this.objectConstructor.construct(this.targetType);
    }

    @Override
    public void startVisitingObject(Object node) {
    }

    @Override
    public void visitArray(Object array, Type componentType) {
        throw new IllegalStateException();
    }

    @Override
    public void visitObjectField(Field f, Type typeOfF, Object obj) {
        try {
            JsonObject jsonObject = this.json.getAsJsonObject();
            String fName = this.getFieldName(f);
            JsonElement jsonChild = jsonObject.get(fName);
            if (jsonChild != null) {
                Object child = this.visitChildAsObject(typeOfF, jsonChild);
                f.set(obj, child);
            } else {
                f.set(obj, null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void visitArrayField(Field f, Type typeOfF, Object obj) {
        try {
            JsonObject jsonObject = this.json.getAsJsonObject();
            String fName = this.getFieldName(f);
            JsonArray jsonChild = (JsonArray)jsonObject.get(fName);
            if (jsonChild != null) {
                Object array = this.visitChildAsArray(typeOfF, jsonChild);
                f.set(obj, array);
            } else {
                f.set(obj, null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private String getFieldName(Field f) {
        FieldNamingStrategy namingPolicy = this.factory.getFieldNamingPolicy();
        return namingPolicy.translateName(f);
    }

    @Override
    public boolean visitFieldUsingCustomHandler(Field f, Type actualTypeOfField, Object parent) {
        try {
            String fName = this.getFieldName(f);
            JsonElement child = this.json.getAsJsonObject().get(fName);
            if (child == null) {
                return true;
            }
            if (JsonNull.INSTANCE.equals(child)) {
                TypeInfo typeInfo = new TypeInfo(actualTypeOfField);
                if (!typeInfo.isPrimitive()) {
                    f.set(parent, null);
                }
                return true;
            }
            JsonDeserializer deserializer = (JsonDeserializer)this.deserializers.getHandlerFor(actualTypeOfField);
            if (deserializer != null) {
                Object value = deserializer.deserialize(child, actualTypeOfField, this.context);
                f.set(parent, value);
                return true;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException();
        }
    }
}

