/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.ForwardingMapper;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.URLRewriter;
import com.google.jstestdriver.URLTranslator;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandServlet
extends HttpServlet {
    private static final long serialVersionUID = 7210927357890630427L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandServlet.class);
    private final Gson gson = new Gson();
    private final CapturedBrowsers capturedBrowsers;
    private final URLTranslator urlTranslator;
    private final URLRewriter urlRewriter;
    private final ForwardingMapper forwardingMapper;

    public CommandServlet(CapturedBrowsers capturedBrowsers, URLTranslator uRLTranslator, URLRewriter uRLRewriter, ForwardingMapper forwardingMapper) {
        this.capturedBrowsers = capturedBrowsers;
        this.urlTranslator = uRLTranslator;
        this.urlRewriter = uRLRewriter;
        this.forwardingMapper = forwardingMapper;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (httpServletRequest.getParameter("listBrowsers") != null) {
            httpServletResponse.getWriter().write(this.listBrowsers());
        } else {
            this.streamResponse(httpServletRequest.getParameter("id"), httpServletResponse.getWriter());
        }
        httpServletResponse.getWriter().flush();
    }

    private SlaveBrowser.CommandResponse getResponse(SlaveBrowser slaveBrowser) {
        SlaveBrowser.CommandResponse commandResponse = null;
        while (commandResponse == null) {
            commandResponse = slaveBrowser.getResponse();
            if (slaveBrowser.isAlive()) continue;
            this.capturedBrowsers.removeSlave(slaveBrowser.getId());
            Response response = new Response();
            response.setBrowser(slaveBrowser.getBrowserInfo());
            response.setResponse("PANIC: browser " + slaveBrowser.getId() + " is not responding anymore, removing it from the list of captured browsers");
            commandResponse = new SlaveBrowser.CommandResponse(this.gson.toJson(response), true);
        }
        return commandResponse;
    }

    private void substituteBrowserInfo(SlaveBrowser.CommandResponse commandResponse) {
        Response response = this.gson.fromJson(commandResponse.getResponse(), Response.class);
        SlaveBrowser slaveBrowser = this.capturedBrowsers.getBrowser(response.getBrowser().getId().toString());
        response.setBrowser(slaveBrowser.getBrowserInfo());
        commandResponse.setResponse(this.gson.toJson(response));
    }

    public void streamResponse(String string, PrintWriter printWriter) {
        SlaveBrowser slaveBrowser = this.capturedBrowsers.getBrowser(string);
        SlaveBrowser.CommandResponse commandResponse = this.getResponse(slaveBrowser);
        this.substituteBrowserInfo(commandResponse);
        String string2 = "{ 'last':" + commandResponse.isLast() + ", 'response':" + commandResponse.getResponse() + " }";
        printWriter.write(string2);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.service(httpServletRequest.getParameter("id"), httpServletRequest.getParameter("data"));
    }

    public String listBrowsers() {
        return this.gson.toJson(this.capturedBrowsers.getBrowsers());
    }

    public void service(String string, String string2) {
        SlaveBrowser slaveBrowser = this.capturedBrowsers.getBrowser(string);
        string2 = this.translateUrls(string2);
        slaveBrowser.createCommand(string2);
    }

    private String translateUrls(String string) {
        JsonCommand jsonCommand = this.gson.fromJson(string, JsonCommand.class);
        if (jsonCommand.getCommand().equals(JsonCommand.CommandType.LOADTEST.getCommand())) {
            List<String> list = jsonCommand.getParameters();
            String string2 = list.get(0);
            List list2 = (List)this.gson.fromJson(string2, new TypeToken<List<FileSource>>(){}.getType());
            for (FileSource fileSource : list2) {
                String string3 = fileSource.getFileSrc();
                if (!string3.startsWith("http://") && !string3.startsWith("https://")) continue;
                String string4 = this.urlRewriter.rewrite(fileSource.getFileSrc());
                if (string4.startsWith("http://") || string4.startsWith("https://")) {
                    String string5 = this.urlTranslator.getTranslation(string4);
                    if (string5 == null) {
                        try {
                            this.urlTranslator.translate(string4);
                            string5 = this.urlTranslator.getTranslation(string4);
                            this.forwardingMapper.addForwardingMapping(string5, string4);
                        }
                        catch (MalformedURLException malformedURLException) {
                            LOGGER.warn("Could not translate URL: " + string4 + " fallback to default URL, things will probably start to act weird...", malformedURLException);
                            string5 = string4;
                        }
                    }
                    fileSource.setBasePath(string4);
                    fileSource.setFileSource(string5);
                    continue;
                }
                fileSource.setBasePath(string4);
                fileSource.setFileSource(string4);
            }
            list.remove(0);
            list.add(0, this.gson.toJson(list2));
            return this.gson.toJson(jsonCommand);
        }
        return string;
    }
}

