/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.guice;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.ActionFactory;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.RunTestsAction;
import com.google.jstestdriver.ThreadedAction;
import com.google.jstestdriver.guice.ThreadedActionProvider;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultThreadedActionProvider
implements ThreadedActionProvider {
    private final ActionFactory actionFactory;
    private final boolean reset;
    private final List<String> dryRunFor;
    private final List<String> tests;
    private final List<String> commands;
    private final ResponseStreamFactory responseStreamFactory;
    private final boolean captureConsole;

    @Inject
    public DefaultThreadedActionProvider(ActionFactory actionFactory, ResponseStreamFactory responseStreamFactory, @Named(value="reset") boolean bl, @Named(value="dryRunFor") List<String> list, @Named(value="captureConsole") boolean bl2, @Named(value="tests") List<String> list2, @Named(value="arguments") List<String> list3) {
        this.actionFactory = actionFactory;
        this.reset = bl;
        this.dryRunFor = list;
        this.captureConsole = bl2;
        this.tests = list2;
        this.commands = list3;
        this.responseStreamFactory = responseStreamFactory;
    }

    @Override
    public List<ThreadedAction> get() {
        ArrayList<ThreadedAction> arrayList = new ArrayList<ThreadedAction>();
        if (this.reset) {
            arrayList.add(this.actionFactory.createResetAction(this.responseStreamFactory));
        }
        if (!this.dryRunFor.isEmpty()) {
            arrayList.add(this.actionFactory.createDryRunAction(this.responseStreamFactory, this.dryRunFor));
        }
        if (!this.tests.isEmpty()) {
            RunTestsAction runTestsAction = this.actionFactory.createRunTestsAction(this.responseStreamFactory, this.tests, this.captureConsole);
            arrayList.add(runTestsAction);
        }
        if (!this.commands.isEmpty()) {
            for (String string : this.commands) {
                arrayList.add(this.actionFactory.createEvalAction(this.responseStreamFactory, string));
            }
        }
        return arrayList;
    }
}

