/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.jstestdriver.BrowserCaptureEvent;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileSetCacheStrategy;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.Lock;
import com.google.jstestdriver.SlaveBrowser;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSetServlet
extends HttpServlet
implements Observer {
    private static final long serialVersionUID = -5224290018208979639L;
    private static final int HEARTBEAT_TIMEOUT = 2000;
    private final Gson gson = new Gson();
    private final Map<String, Lock> locks = new ConcurrentHashMap<String, Lock>();
    private final CapturedBrowsers capturedBrowsers;
    private final FileSetCacheStrategy strategy = new FileSetCacheStrategy();
    private final FilesCache filesCache;

    public FileSetServlet(CapturedBrowsers capturedBrowsers, FilesCache filesCache) {
        this.capturedBrowsers = capturedBrowsers;
        this.filesCache = filesCache;
        this.capturedBrowsers.addObserver(this);
    }

    @Override
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getParameter("id");
        String string2 = httpServletRequest.getParameter("session");
        String string3 = httpServletRequest.getParameter("sessionId");
        if (string2 == null && string3 != null) {
            this.sessionHeartBeat(string, string3);
        } else if (string2.equals("start")) {
            this.startSession(string, httpServletResponse.getWriter());
        } else if (string2.equals("stop")) {
            this.stopSession(string, string3, httpServletResponse.getWriter());
        }
    }

    private void sessionHeartBeat(String string, String string2) {
        Lock lock = this.locks.get(string);
        if (lock.getSessionId().equals(string2)) {
            lock.setLastHeartBeat(new Date().getTime());
        }
    }

    public void stopSession(String string, String string2, PrintWriter printWriter) {
        Lock lock = this.locks.get(string);
        lock.unlock(string2);
        printWriter.flush();
    }

    public void startSession(String string, PrintWriter printWriter) {
        String string2;
        SlaveBrowser slaveBrowser = this.capturedBrowsers.getBrowser(string);
        Lock lock = this.locks.get(string);
        if (lock.tryLock(string2 = UUID.randomUUID().toString())) {
            printWriter.write(string2);
        } else if (!slaveBrowser.isCommandRunning() && slaveBrowser.peekCommand() == null || new Date().getTime() - lock.getLastHeartBeat() > 2000L) {
            lock.forceUnlock();
            SlaveBrowser slaveBrowser2 = this.capturedBrowsers.getBrowser(string);
            slaveBrowser2.clearCommandRunning();
            slaveBrowser2.clearResponseQueue();
            this.filesCache.clear();
            printWriter.write(lock.tryLock(string2) ? string2 : "FAILED");
        } else {
            printWriter.write("FAILED");
        }
        printWriter.flush();
    }

    @Override
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getParameter("data");
        String string2 = httpServletRequest.getParameter("id");
        if (string != null) {
            this.uploadFiles(string2, string);
        } else {
            this.checkFileSet(httpServletRequest.getParameter("fileSet"), string2, httpServletResponse.getWriter());
        }
    }

    public void checkFileSet(String string, String string2, PrintWriter printWriter) {
        SlaveBrowser slaveBrowser;
        Set<FileInfo> set;
        Collection collection = (Collection)this.gson.fromJson(string, new TypeToken<Collection<FileInfo>>(){}.getType());
        Set<FileInfo> set2 = this.strategy.createExpiredFileSet(collection, set = (slaveBrowser = this.capturedBrowsers.getBrowser(string2)).getFileSet());
        if (!set2.isEmpty()) {
            if (slaveBrowser.getBrowserInfo().getName().contains("Safari") || slaveBrowser.getBrowserInfo().getName().contains("Opera") || slaveBrowser.getBrowserInfo().getName().contains("Konqueror")) {
                set2.clear();
                for (FileInfo fileInfo : collection) {
                    set2.add(fileInfo);
                }
            }
            Set<FileInfo> set3 = this.filterServeOnlyFiles(set2);
            printWriter.write(this.gson.toJson(set3));
        }
        printWriter.flush();
    }

    private Set<FileInfo> filterServeOnlyFiles(Set<FileInfo> set) {
        LinkedHashSet<FileInfo> linkedHashSet = new LinkedHashSet<FileInfo>();
        Set<String> set2 = this.filesCache.getAllFileNames();
        for (FileInfo fileInfo : set) {
            if (fileInfo.isServeOnly() && set2.contains(fileInfo.getFileName()) && this.filesCache.getFileInfo(fileInfo.getFileName()).getTimestamp() >= fileInfo.getTimestamp()) continue;
            linkedHashSet.add(fileInfo);
        }
        return linkedHashSet;
    }

    @Override
    public void update(Observable observable, Object object) {
        BrowserCaptureEvent browserCaptureEvent = (BrowserCaptureEvent)object;
        if (browserCaptureEvent.event == BrowserCaptureEvent.Event.CONNECTED) {
            this.locks.put(browserCaptureEvent.getBrowser().getId(), new Lock());
        }
    }

    public void uploadFiles(String string, String string2) {
        Collection collection = (Collection)this.gson.fromJson(string2, new TypeToken<Collection<FileInfo>>(){}.getType());
        for (FileInfo fileInfo : collection) {
            String string3 = fileInfo.getFileName();
            this.filesCache.addFile(string3, fileInfo);
        }
    }
}

