/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.token;

import com.google.jstestdriver.token.ConcreteToken;
import com.google.jstestdriver.token.Token;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenEmitter
implements Iterator<Token> {
    private final BufferedInputStream stream;
    private final Token[] tokens;
    private Token currentToken = null;
    private TokenBuilder tokenBuilder = new TokenBuilder();

    public TokenEmitter(BufferedInputStream bufferedInputStream, Token[] tokenArray) {
        this.stream = bufferedInputStream;
        this.tokens = tokenArray;
    }

    @Override
    public Token next() {
        this.stream.mark(Integer.MAX_VALUE);
        if (this.currentToken != null) {
            Token token = this.currentToken;
            this.currentToken = null;
            return token;
        }
        try {
            while (this.stream.available() > 0) {
                for (Token token : this.tokens) {
                    Token token2 = token.create(this.stream);
                    if (token2 == null) continue;
                    if (this.tokenBuilder.hasToken()) {
                        this.currentToken = token2;
                        token2 = this.tokenBuilder.toToken();
                        this.tokenBuilder = new TokenBuilder();
                        return token2;
                    }
                    return token2;
                }
                this.tokenBuilder.append(this.stream.read());
                this.stream.mark(Integer.MAX_VALUE);
            }
            if (this.currentToken != null) {
                Token iOException = this.currentToken;
                this.currentToken = null;
                return iOException;
            }
            if (this.tokenBuilder.hasToken()) {
                Token token = this.tokenBuilder.toToken();
                this.tokenBuilder = new TokenBuilder();
                return token;
            }
            throw new IndexOutOfBoundsException();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.stream.available() > 0 || this.currentToken != null || this.tokenBuilder.hasToken();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class TokenBuilder {
        private char[] buffer = new char[256];
        private int marker = 0;

        public void append(int n) {
            if (this.marker >= this.buffer.length) {
                char[] cArray = this.buffer;
                this.buffer = new char[cArray.length * 2];
                System.arraycopy(cArray, 0, this.buffer, 0, this.marker);
            }
            this.buffer[this.marker++] = (char)n;
        }

        public boolean hasToken() {
            return this.marker > 0;
        }

        public Token toToken() {
            char[] cArray = new char[this.marker];
            System.arraycopy(this.buffer, 0, cArray, 0, this.marker);
            return new ConcreteToken(cArray);
        }
    }
}

