/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.ThreadedAction;
import com.google.jstestdriver.hooks.TestsPreProcessor;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunTestsAction
extends ThreadedAction {
    private final List<String> tests;
    private final boolean captureConsole;
    private final Set<TestsPreProcessor> preProcessors;

    public RunTestsAction(ResponseStreamFactory responseStreamFactory, List<String> list, boolean bl, Set<TestsPreProcessor> set) {
        super(responseStreamFactory);
        this.tests = list;
        this.captureConsole = bl;
        this.preProcessors = set;
    }

    @Override
    public void run(String string, JsTestDriverClient jsTestDriverClient) {
        List<String> list = this.tests;
        for (TestsPreProcessor testsPreProcessor : this.preProcessors) {
            list = testsPreProcessor.process(string, list.iterator());
        }
        ResponseStream responseStream = this.responseStreamFactory.getRunTestsActionResponseStream(string);
        if (list.size() == 1 && list.get(0).equals("all")) {
            jsTestDriverClient.runAllTests(string, responseStream, this.captureConsole);
        } else if (list.size() > 0) {
            jsTestDriverClient.runTests(string, responseStream, list, this.captureConsole);
        }
    }

    public List<String> getTests() {
        return this.tests;
    }

    public boolean isCaptureConsole() {
        return this.captureConsole;
    }
}

