/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.Gson;
import com.google.gson.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParameterizedTypeHandlerMap<T> {
    private final Map<Type, T> map = new HashMap<Type, T>();
    private boolean modifiable = true;

    ParameterizedTypeHandlerMap() {
    }

    public synchronized void register(Type typeOfT, T value) {
        if (!this.modifiable) {
            throw new IllegalStateException("Attempted to modify an unmodifiable map.");
        }
        if (this.hasSpecificHandlerFor(typeOfT)) {
            Gson.logger.log(Level.WARNING, "Overriding the existing type handler for " + typeOfT);
        }
        this.map.put(typeOfT, value);
    }

    public synchronized void registerIfAbsent(ParameterizedTypeHandlerMap<T> other) {
        if (!this.modifiable) {
            throw new IllegalStateException("Attempted to modify an unmodifiable map.");
        }
        for (Map.Entry<Type, T> entry : other.entrySet()) {
            if (this.map.containsKey(entry.getKey())) continue;
            this.register(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void makeUnmodifiable() {
        this.modifiable = false;
    }

    public synchronized T getHandlerFor(Type type) {
        T handler = this.getRawHandlerFor(type);
        Type rawType = type;
        if (handler == null && type instanceof ParameterizedType) {
            rawType = ((ParameterizedType)type).getRawType();
            handler = this.map.get(rawType);
        }
        if (handler == null && rawType instanceof Class) {
            Class rawClass = (Class)rawType;
            if (Map.class.isAssignableFrom(rawClass)) {
                handler = this.map.get(Map.class);
            } else if (Collection.class.isAssignableFrom(rawClass)) {
                handler = this.map.get(Collection.class);
            } else if (Enum.class.isAssignableFrom(rawClass)) {
                handler = this.map.get(Enum.class);
            }
        }
        return handler;
    }

    private synchronized T getRawHandlerFor(Type type) {
        T handler = this.map.get(type);
        if (type instanceof Map) {
            handler = this.map.get(Map.class);
        } else if (type instanceof Collection) {
            handler = this.map.get(Collection.class);
        }
        return handler;
    }

    public synchronized boolean hasAnyHandlerFor(Type type) {
        return this.getHandlerFor(type) != null;
    }

    public synchronized boolean hasSpecificHandlerFor(Type type) {
        return this.map.containsKey(type);
    }

    public synchronized ParameterizedTypeHandlerMap<T> copyOf() {
        ParameterizedTypeHandlerMap<T> copy = new ParameterizedTypeHandlerMap<T>();
        for (Map.Entry<Type, T> entry : this.map.entrySet()) {
            copy.register(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public synchronized Set<Map.Entry<Type, T>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry<Type, T> entry : this.map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(this.typeToString(entry.getKey())).append(':');
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    private String typeToString(Type type) {
        return TypeUtils.toRawClass(type).getSimpleName();
    }
}

