/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfo {
    private String file;
    private Long timestamp;
    private transient boolean isPatch;
    private boolean serveOnly;
    private List<FileInfo> patches;
    private String data;

    public String toString() {
        return "FileInfo [file=" + this.file + ", isPatch=" + this.isPatch + ", serveOnly=" + this.serveOnly + ", timestamp=" + this.timestamp + "]";
    }

    public String getData() {
        return this.data == null ? "" : this.data;
    }

    public void setData(String string) {
        this.data = string;
    }

    public FileInfo() {
    }

    public FileInfo(String string, long l, boolean bl, boolean bl2, String string2) {
        this.file = string;
        this.timestamp = l;
        this.isPatch = bl;
        this.serveOnly = bl2;
        this.data = string2;
    }

    public List<FileInfo> getPatches() {
        if (this.patches != null) {
            return new LinkedList<FileInfo>(this.patches);
        }
        return new LinkedList<FileInfo>();
    }

    public void addPatch(FileInfo fileInfo) {
        if (this.patches == null) {
            this.patches = new LinkedList<FileInfo>();
        }
        this.patches.add(fileInfo);
    }

    public boolean isServeOnly() {
        return this.serveOnly;
    }

    public String getFileName() {
        return this.file;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isPatch() {
        return this.isPatch;
    }

    public boolean canLoad() {
        return !this.file.startsWith("http://") && !this.file.startsWith("https://");
    }

    public boolean equals(Object object) {
        return this.hashCode() == object.hashCode();
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

