/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.Flags;
import com.google.jstestdriver.FlagsImpl;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class FlagsParser {
    public Flags parseArgument(String[] stringArray) throws CmdLineException {
        FlagsImpl flagsImpl = new FlagsImpl();
        CmdLineParser.registerHandler(List.class, StringListOptionHandler.class);
        CmdLineParser cmdLineParser = new CmdLineParser(flagsImpl);
        try {
            cmdLineParser.parseArgument(stringArray);
        }
        catch (CmdLineException cmdLineException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cmdLineParser.printUsage(byteArrayOutputStream);
            throw new CmdLineException(cmdLineException.getMessage() + "\n" + byteArrayOutputStream.toString());
        }
        if (stringArray.length == 0 || flagsImpl.getDisplayHelp()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cmdLineParser.printUsage(byteArrayOutputStream);
            throw new CmdLineException(byteArrayOutputStream.toString());
        }
        return flagsImpl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringListOptionHandler
    extends OptionHandler<List<String>> {
        public StringListOptionHandler(CmdLineParser cmdLineParser, OptionDef optionDef, Setter<? super List<String>> setter) {
            super(cmdLineParser, optionDef, setter);
        }

        @Override
        public String getDefaultMetaVariable() {
            return "VAR";
        }

        @Override
        public int parseArguments(Parameters parameters) throws CmdLineException {
            String[] stringArray = parameters.getParameter(0).split(",");
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (String string : stringArray) {
                arrayList.add(string.trim());
            }
            this.setter.addValue(arrayList);
            return 1;
        }
    }
}

