/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserAgentParser {
    private static final Pattern BROWSER_NAME_AND_VERSION = Pattern.compile("(Safari|Firefox|Opera|Konqueror)/([0-9\\.]+)");
    private static final Pattern CHROME_VERSION = Pattern.compile("Chrome/([0-9\\.]+)");
    private static final Pattern MSIE_VERSION = Pattern.compile("; MSIE ([0-9\\.]+);");
    private String userAgentName = "";
    private String userAgentVersion = "";
    private String userAgentOs = "";

    public void parse(String string) {
        String string2 = string.toLowerCase();
        if (string2.contains("windows")) {
            this.userAgentOs = "Windows";
        } else if (string2.contains("linux")) {
            this.userAgentOs = "Linux";
        } else if (string2.contains("iphone")) {
            this.userAgentOs = "iPhone OS";
        } else if (string2.contains("mac")) {
            this.userAgentOs = "Mac OS";
        }
        if (string.contains("Chrome")) {
            this.userAgentName = "Chrome";
            Matcher matcher = CHROME_VERSION.matcher(string);
            if (matcher.find()) {
                this.userAgentVersion = matcher.group(1);
            }
        } else if (string.contains("MSIE")) {
            this.userAgentName = "Microsoft Internet Explorer";
            Matcher matcher = MSIE_VERSION.matcher(string);
            if (matcher.find()) {
                this.userAgentVersion = matcher.group(1);
            }
        } else {
            Matcher matcher = BROWSER_NAME_AND_VERSION.matcher(string);
            if (matcher.find()) {
                this.userAgentName = matcher.group(1);
                this.userAgentVersion = matcher.group(2);
            } else {
                this.userAgentName = string;
            }
        }
    }

    public String getName() {
        return this.userAgentName;
    }

    public String getVersion() {
        return this.userAgentVersion;
    }

    public String getOs() {
        return this.userAgentOs;
    }
}

