/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.ObjectNavigator;
import com.google.gson.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class JsonPrimitive
extends JsonElement {
    private Object value;

    public JsonPrimitive(Boolean bool) {
        this.value = bool;
    }

    public JsonPrimitive(Number number) {
        this.value = number;
    }

    public JsonPrimitive(String string) {
        this.value = string;
    }

    public JsonPrimitive(Character c) {
        this.value = String.valueOf(c);
    }

    public JsonPrimitive(char c) {
        this.value = String.valueOf(c);
    }

    JsonPrimitive(Object primitive) {
        this.setValue(primitive);
    }

    void setValue(Object primitive) {
        if (primitive instanceof Character) {
            char c = ((Character)primitive).charValue();
            this.value = String.valueOf(c);
        } else {
            Preconditions.checkArgument(primitive instanceof Number || ObjectNavigator.isPrimitiveOrString(primitive));
            this.value = primitive;
        }
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    Boolean getAsBooleanWrapper() {
        return (Boolean)this.value;
    }

    public boolean getAsBoolean() {
        return (Boolean)this.value;
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public Number getAsNumber() {
        return (Number)this.value;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public String getAsString() {
        return (String)this.value;
    }

    public double getAsDouble() {
        return ((Number)this.value).doubleValue();
    }

    public BigDecimal getAsBigDecimal() {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        return new BigDecimal(this.value.toString());
    }

    public BigInteger getAsBigInteger() {
        if (this.value instanceof BigInteger) {
            return (BigInteger)this.value;
        }
        return new BigInteger(this.value.toString());
    }

    public float getAsFloat() {
        return ((Number)this.value).floatValue();
    }

    public long getAsLong() {
        return ((Number)this.value).longValue();
    }

    public short getAsShort() {
        return ((Number)this.value).shortValue();
    }

    public int getAsInt() {
        return ((Number)this.value).intValue();
    }

    public byte getAsByte() {
        return ((Number)this.value).byteValue();
    }

    public char getAsCharacter() {
        return this.getAsString().charAt(0);
    }

    Object getAsObject() {
        return this.value;
    }

    protected void toString(StringBuilder sb) {
        if (this.value != null) {
            if (this.value instanceof String) {
                sb.append('\"');
                sb.append(this.value);
                sb.append('\"');
            } else {
                sb.append(this.value);
            }
        }
    }
}

