/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.MemoryRefStack;
import com.google.gson.Preconditions;
import com.google.gson.TypeInfo;
import com.google.gson.TypeInfoFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectNavigator {
    private final ExclusionStrategy exclusionStrategy;
    private final MemoryRefStack<Object> ancestors;
    private final Object obj;
    private final Type objType;
    private static final Class[] PRIMITIVE_TYPES = new Class[]{Integer.TYPE, Long.TYPE, Short.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE, Boolean.TYPE, Integer.class, Long.class, Short.class, Float.class, Double.class, Byte.class, Boolean.class};

    ObjectNavigator(Object obj, Type objType, ExclusionStrategy exclusionStrategy, MemoryRefStack<Object> ancestors) {
        Preconditions.checkNotNull(exclusionStrategy);
        Preconditions.checkNotNull(ancestors);
        this.obj = obj;
        this.objType = objType;
        this.exclusionStrategy = exclusionStrategy;
        this.ancestors = ancestors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(Visitor visitor) {
        if (this.obj == null) {
            return;
        }
        TypeInfo objTypeInfo = new TypeInfo(this.objType);
        if (this.exclusionStrategy.shouldSkipClass(objTypeInfo.getRawClass())) {
            return;
        }
        if (this.ancestors.contains(this.obj)) {
            throw new IllegalStateException("Circular reference found: " + this.obj);
        }
        this.ancestors.push(this.obj);
        try {
            boolean visitedWithCustomHandler = visitor.visitUsingCustomHandler(this.obj, this.objType);
            if (!visitedWithCustomHandler) {
                if (objTypeInfo.isArray()) {
                    visitor.visitArray(this.obj, this.objType);
                } else {
                    visitor.startVisitingObject(this.obj);
                    for (Class<?> curr = objTypeInfo.getRawClass(); curr != null && !curr.equals(Object.class); curr = curr.getSuperclass()) {
                        if (curr.isSynthetic()) continue;
                        this.navigateClassFields(this.obj, curr, visitor);
                    }
                }
            }
        }
        finally {
            this.ancestors.pop();
        }
    }

    private void navigateClassFields(Object obj, Class<?> clazz, Visitor visitor) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject f : fields) {
            boolean visitedWithCustomHandler;
            TypeInfo fieldTypeInfo = TypeInfoFactory.getTypeInfoForField((Field)f, this.objType);
            Type actualTypeOfField = fieldTypeInfo.getActualType();
            if (this.exclusionStrategy.shouldSkipField((Field)f) || (visitedWithCustomHandler = visitor.visitFieldUsingCustomHandler((Field)f, actualTypeOfField, obj))) continue;
            if (fieldTypeInfo.isArray()) {
                visitor.visitArrayField((Field)f, actualTypeOfField, obj);
                continue;
            }
            visitor.visitObjectField((Field)f, actualTypeOfField, obj);
        }
    }

    static boolean isPrimitiveOrString(Object target) {
        if (target instanceof String) {
            return true;
        }
        Class<?> classOfPrimitive = target.getClass();
        for (Class standardPrimitive : PRIMITIVE_TYPES) {
            if (!standardPrimitive.isAssignableFrom(classOfPrimitive)) continue;
            return true;
        }
        return false;
    }

    public static interface Visitor {
        public void startVisitingObject(Object var1);

        public void visitArray(Object var1, Type var2);

        public void visitObjectField(Field var1, Type var2, Object var3);

        public void visitArrayField(Field var1, Type var2, Object var3);

        public boolean visitUsingCustomHandler(Object var1, Type var2);

        public boolean visitFieldUsingCustomHandler(Field var1, Type var2, Object var3);
    }
}

