/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.DryRunAction;
import com.google.jstestdriver.EvalAction;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.ResetAction;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.RunTestsAction;
import com.google.jstestdriver.ServerStartupAction;
import com.google.jstestdriver.URLRewriter;
import com.google.jstestdriver.URLTranslator;
import com.google.jstestdriver.hooks.TestsPreProcessor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ActionFactory {
    Map<Class<?>, List<Observer>> observers = new HashMap();
    private final Provider<JsTestDriverClient> clientProvider;
    private final Set<TestsPreProcessor> testPreProcessors;

    @Inject
    public ActionFactory(Provider<JsTestDriverClient> provider, Set<TestsPreProcessor> set) {
        this.clientProvider = provider;
        this.testPreProcessors = set;
    }

    public ServerStartupAction getServerStartupAction(Integer n, CapturedBrowsers capturedBrowsers, FilesCache filesCache, URLTranslator uRLTranslator, URLRewriter uRLRewriter) {
        ServerStartupAction serverStartupAction = new ServerStartupAction(n, capturedBrowsers, filesCache, uRLTranslator, uRLRewriter);
        if (this.observers.containsKey(CapturedBrowsers.class)) {
            for (Observer observer : this.observers.get(CapturedBrowsers.class)) {
                capturedBrowsers.addObserver(observer);
            }
        }
        if (this.observers.containsKey(ServerStartupAction.class)) {
            serverStartupAction.addObservers(this.observers.get(ServerStartupAction.class));
        }
        return serverStartupAction;
    }

    public void registerListener(Class<?> clazz, Observer observer) {
        if (!this.observers.containsKey(clazz)) {
            this.observers.put(clazz, new LinkedList());
        }
        this.observers.get(clazz).add(observer);
    }

    public ResetAction createResetAction(ResponseStreamFactory responseStreamFactory) {
        return new ResetAction(responseStreamFactory);
    }

    public DryRunAction createDryRunAction(ResponseStreamFactory responseStreamFactory, List<String> list) {
        return new DryRunAction(responseStreamFactory, list);
    }

    public RunTestsAction createRunTestsAction(ResponseStreamFactory responseStreamFactory, List<String> list, boolean bl) {
        return new RunTestsAction(responseStreamFactory, list, bl, this.testPreProcessors);
    }

    public EvalAction createEvalAction(ResponseStreamFactory responseStreamFactory, String string) {
        return new EvalAction(responseStreamFactory, string);
    }

    public JsTestDriverClient getJsTestDriverClient(Set<FileInfo> set, String string) {
        return this.clientProvider.get();
    }
}

