/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.Action;
import com.google.jstestdriver.BrowserShutdownAction;
import com.google.jstestdriver.ProcessFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserStartupAction
implements Action,
Observer {
    private static final Logger logger = LoggerFactory.getLogger(BrowserStartupAction.class);
    private final CountDownLatch latch;
    private final List<String> browserPath;
    private final String serverAddress;
    private volatile List<Process> processes = new ArrayList<Process>();
    private final ProcessFactory processFactory;

    public BrowserStartupAction(List<String> list, String string, ProcessFactory processFactory, CountDownLatch countDownLatch) {
        this.browserPath = list;
        this.serverAddress = string;
        this.processFactory = processFactory;
        this.latch = countDownLatch;
    }

    @Override
    public void run() {
        try {
            String string = String.format("%s/capture", this.serverAddress);
            for (String string2 : this.browserPath) {
                try {
                    this.processes.add(this.processFactory.start(string2, string));
                }
                catch (IOException iOException) {
                    logger.error("Could not start: {} because {}", (Object)string2, (Object)iOException.toString());
                }
            }
            if (!this.latch.await(30L, TimeUnit.SECONDS)) {
                long l = this.latch.getCount();
                if (l < (long)this.browserPath.size()) {
                    logger.warn("Not all browsers were captured continuing anyway...");
                } else {
                    logger.error("None of the browsers were captured after 30 seconds");
                    new BrowserShutdownAction(this).run();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error("Error in starting browsers: {}", (Object)interruptedException.toString());
        }
    }

    public List<Process> getProcesses() {
        return this.processes;
    }

    @Override
    public void update(Observable observable, Object object) {
        this.latch.countDown();
    }

    public List<String> getBrowserPath() {
        return this.browserPath;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }
}

