/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.FileInfo;
import java.io.File;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonPathResolver {
    private static final char PATH_SEPARATOR = File.separatorChar;
    private final List<FileInfo> files;

    public CommonPathResolver(List<FileInfo> list) {
        this.files = list;
    }

    public String resolve() {
        if (this.files.isEmpty()) {
            return "";
        }
        if (this.files.size() == 1) {
            return new File(this.files.get(0).getFileName()).getParent() + PATH_SEPARATOR;
        }
        Iterator<FileInfo> iterator = this.files.iterator();
        String string = iterator.next().getFileName();
        do {
            string = this.getLongestCommonPath(string, iterator.next().getFileName());
        } while (iterator.hasNext());
        return string;
    }

    private String getLongestCommonPath(String string, String string2) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length && i < cArray2.length && cArray[i] == cArray2[i]; ++i) {
            if (cArray[i] != PATH_SEPARATOR || cArray2[i] != PATH_SEPARATOR) continue;
            n = i;
        }
        return string.substring(0, n + 1);
    }
}

