/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.PathResolver;
import com.google.jstestdriver.PathRewriter;
import com.google.jstestdriver.Plugin;
import java.io.File;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.oro.io.GlobFilenameFilter;
import org.jvyaml.YAML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ConfigurationParser {
    private static final List<String> EMPTY_LIST = Lists.newArrayList();
    private final Set<FileInfo> filesList = new LinkedHashSet<FileInfo>();
    private final File basePath;
    private final Reader configReader;
    private final PathRewriter pathRewriter;
    private String server = "";
    private List<Plugin> plugins = new LinkedList<Plugin>();
    private PathResolver pathResolver = new PathResolver();

    public ConfigurationParser(File file, Reader reader, PathRewriter pathRewriter) {
        this.basePath = file;
        this.configReader = reader;
        this.pathRewriter = pathRewriter;
    }

    public void parse() {
        Map map = (Map)YAML.load(this.configReader);
        LinkedHashSet<FileInfo> linkedHashSet = new LinkedHashSet<FileInfo>();
        LinkedHashSet<FileInfo> linkedHashSet2 = new LinkedHashSet<FileInfo>();
        if (map.containsKey("load")) {
            linkedHashSet.addAll(this.resolveFiles((List)map.get("load"), false));
        }
        if (map.containsKey("exclude")) {
            linkedHashSet2.addAll(this.resolveFiles((List)map.get("exclude"), false));
        }
        if (map.containsKey("server")) {
            this.server = (String)map.get("server");
        }
        if (map.containsKey("plugin")) {
            for (Map map2 : (List)map.get("plugin")) {
                this.plugins.add(new Plugin((String)map2.get("name"), (String)map2.get("jar"), (String)map2.get("module"), this.createArgsList((String)map2.get("args"))));
            }
        }
        if (map.containsKey("serve")) {
            Set<FileInfo> set = this.resolveFiles((List)map.get("serve"), true);
            linkedHashSet.addAll((Collection<FileInfo>)set);
        }
        this.filesList.addAll(this.consolidatePatches(linkedHashSet));
        this.filesList.removeAll(linkedHashSet2);
    }

    private List<String> createArgsList(String string) {
        String[] stringArray;
        if (string == null) {
            return EMPTY_LIST;
        }
        LinkedList<String> linkedList = Lists.newLinkedList();
        for (String string2 : stringArray = string.split(",")) {
            linkedList.add(string2.trim());
        }
        return linkedList;
    }

    private Set<FileInfo> consolidatePatches(Set<FileInfo> set) {
        LinkedHashSet<FileInfo> linkedHashSet = new LinkedHashSet<FileInfo>(set.size());
        FileInfo fileInfo = null;
        for (FileInfo fileInfo2 : set) {
            if (fileInfo2.isPatch()) {
                if (fileInfo == null) {
                    throw new IllegalStateException("Patch " + fileInfo2 + " without a core file to patch");
                }
                fileInfo.addPatch(fileInfo2);
                continue;
            }
            linkedHashSet.add(fileInfo2);
            fileInfo = fileInfo2;
        }
        return linkedHashSet;
    }

    private Set<FileInfo> resolveFiles(List<String> list, boolean bl) {
        if (list != null) {
            LinkedHashSet<FileInfo> linkedHashSet = new LinkedHashSet<FileInfo>();
            for (String string : list) {
                String string2;
                Object object;
                boolean bl2 = (string = this.pathRewriter.rewrite(string)).startsWith("patch");
                if (bl2) {
                    object = string.split(" ", 2);
                    string = object[1].trim();
                }
                if (string.startsWith("http://") || string.startsWith("https://")) {
                    linkedHashSet.add(new FileInfo(string, -1L, false, false, null));
                    continue;
                }
                object = this.basePath != null ? new File(this.basePath.getAbsoluteFile(), string) : new File(string);
                File file = ((File)object).getAbsoluteFile();
                File file2 = file.getParentFile().getAbsoluteFile();
                String[] stringArray = file2.list(new GlobFilenameFilter(string2 = ((File)object).getName(), 1));
                if (stringArray == null || stringArray.length == 0) {
                    String string3 = "The patterns/paths " + string + " used in the configuration" + " file didn't match any file, the files patterns/paths need to be relative to" + " the configuration file.";
                    System.err.println(string3);
                    throw new RuntimeException(string3);
                }
                Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
                for (String string4 : stringArray) {
                    String string5 = this.pathResolver.resolvePath(file2.getAbsolutePath().replaceAll("\\\\", "/") + "/" + string4.replaceAll("\\\\", "/"));
                    File file3 = new File(string5);
                    linkedHashSet.add(new FileInfo(string5, file3.lastModified(), bl2, bl, null));
                }
            }
            return linkedHashSet;
        }
        return Collections.emptySet();
    }

    public Set<FileInfo> getFilesList() {
        return this.filesList;
    }

    public String getServer() {
        return this.server;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }
}

