/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.Flags;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlagsImpl
implements Flags {
    private Integer port = -1;
    private String server;
    private String testOutput = "";
    private List<String> browser = new ArrayList<String>();
    private boolean reset;
    private String config = "jsTestDriver.conf";
    private List<String> tests = new ArrayList<String>();
    private boolean displayHelp = false;
    private boolean verbose = false;
    private boolean captureConsole = false;
    private boolean preloadFiles = false;
    private List<String> dryRunFor = new ArrayList<String>();
    @Argument
    private List<String> arguments = new ArrayList<String>();

    @Option(name="--port", usage="The port on which to start the JsTestDriver server")
    public void setPort(Integer n) {
        this.port = n;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Option(name="--server", usage="The server to which to send the command")
    public void setServer(String string) {
        this.server = string;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public List<String> getArguments() {
        return this.arguments;
    }

    @Option(name="--testOutput", usage="A directory to which serialize the results of the tests as XML")
    public void setTestOutput(String string) {
        this.testOutput = string;
    }

    @Override
    public String getTestOutput() {
        return this.testOutput;
    }

    @Option(name="--browser", usage="The path to the browser executable")
    public void setBrowser(List<String> list) {
        this.browser = list;
    }

    @Override
    public List<String> getBrowser() {
        return this.browser;
    }

    @Option(name="--reset", usage="Resets the runner")
    public void setReset(boolean bl) {
        this.reset = bl;
    }

    @Override
    public boolean getReset() {
        return this.reset;
    }

    @Option(name="--config", usage="Loads the configuration file")
    public void setConfig(String string) {
        this.config = string;
    }

    @Override
    public String getConfig() {
        return this.config;
    }

    @Option(name="--tests", usage="Run the tests specified in the form testCase.testName")
    public void setTests(List<String> list) {
        this.tests = list;
    }

    @Override
    public List<String> getTests() {
        return this.tests;
    }

    @Option(name="--help", usage="Help")
    public void setDisplayHelp(boolean bl) {
        this.displayHelp = bl;
    }

    @Override
    public boolean getDisplayHelp() {
        return this.displayHelp;
    }

    @Option(name="--verbose", usage="Displays more information during a run")
    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @Override
    public boolean getVerbose() {
        return this.verbose;
    }

    @Option(name="--captureConsole", usage="Capture the console (if possible) from the browser")
    public void setCaptureConsole(boolean bl) {
        this.captureConsole = bl;
    }

    @Override
    public boolean getCaptureConsole() {
        return this.captureConsole;
    }

    @Option(name="--preloadFiles", usage="Preload the js files")
    public void setPreloadFiles(boolean bl) {
        this.preloadFiles = bl;
    }

    @Override
    public boolean getPreloadFiles() {
        return this.preloadFiles;
    }

    @Option(name="--dryRunFor", usage="Outputs the number of tests that are going to be run as well as their names for a set of expressions or all to see all the tests")
    public void setDryRunFor(List<String> list) {
        this.dryRunFor = list;
    }

    @Override
    public List<String> getDryRunFor() {
        return this.dryRunFor;
    }

    @Override
    public boolean hasWork() {
        return this.getTests().size() > 0 || this.getReset() || !this.getArguments().isEmpty() || this.getPreloadFiles() || !this.getDryRunFor().isEmpty();
    }
}

