/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.FileReader;
import com.google.jstestdriver.JsTestDriverFileFilter;
import com.google.jstestdriver.hooks.FileLoadPostProcessor;
import com.google.jstestdriver.hooks.FileLoadPreProcessor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingFileLoader
implements FileLoader {
    private final JsTestDriverFileFilter filter;
    private final FileReader reader;
    private final Set<FileLoadPostProcessor> postprocessors;
    private final Set<FileLoadPreProcessor> preProcessors;

    @Inject
    public ProcessingFileLoader(JsTestDriverFileFilter jsTestDriverFileFilter, FileReader fileReader, Set<FileLoadPostProcessor> set, Set<FileLoadPreProcessor> set2) {
        this.filter = jsTestDriverFileFilter;
        this.reader = fileReader;
        this.postprocessors = set;
        this.preProcessors = set2;
    }

    @Override
    public List<FileInfo> loadFiles(Collection<FileInfo> collection, boolean bl) {
        LinkedList<FileInfo> linkedList = new LinkedList<FileInfo>();
        try {
            for (FileInfo fileInfo : this.preProcessFiles(collection)) {
                FileInfo fileInfo2 = this.loadFile(bl, fileInfo);
                fileInfo2 = this.postProcessFile(fileInfo2);
                linkedList.add(fileInfo2);
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        return linkedList;
    }

    private FileInfo loadFile(boolean bl, FileInfo fileInfo) {
        if (!fileInfo.canLoad()) {
            return fileInfo;
        }
        StringBuilder stringBuilder = new StringBuilder();
        long l = fileInfo.getTimestamp();
        stringBuilder.append(this.filter.filterFile(this.reader.readFile(fileInfo.getFileName()), !bl));
        List<FileInfo> list = fileInfo.getPatches();
        if (list != null) {
            for (FileInfo fileInfo2 : list) {
                stringBuilder.append(this.reader.readFile(fileInfo2.getFileName()));
            }
        }
        return new FileInfo(fileInfo.getFileName(), l, false, fileInfo.isServeOnly(), stringBuilder.toString());
    }

    private FileInfo postProcessFile(FileInfo fileInfo) {
        for (FileLoadPostProcessor fileLoadPostProcessor : this.postprocessors) {
            fileInfo = fileLoadPostProcessor.process(fileInfo);
        }
        return fileInfo;
    }

    private List<FileInfo> preProcessFiles(Collection<FileInfo> collection) {
        List<FileInfo> list = new LinkedList<FileInfo>(collection);
        for (FileLoadPreProcessor fileLoadPreProcessor : this.preProcessors) {
            list = fileLoadPreProcessor.process(list);
        }
        return list;
    }
}

