/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.FailureAccumulator;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.TestResultGenerator;
import com.google.jstestdriver.output.TestResultListener;
import java.util.Collection;

public class RunTestsActionResponseStream
implements ResponseStream {
    private final TestResultGenerator testResultGenerator;
    private final TestResultListener listener;
    private final FailureAccumulator accumulator;

    public RunTestsActionResponseStream(TestResultGenerator testResultGenerator, TestResultListener testResultListener, FailureAccumulator failureAccumulator) {
        this.testResultGenerator = testResultGenerator;
        this.listener = testResultListener;
        this.accumulator = failureAccumulator;
    }

    public void stream(Response response) {
        Collection<TestResult> collection = this.testResultGenerator.getTestResults(response);
        for (TestResult testResult : collection) {
            if (testResult.getResult() == TestResult.Result.failed || testResult.getResult() == TestResult.Result.error) {
                this.accumulator.add();
            }
            this.listener.onTestComplete(testResult);
        }
    }

    public void finish() {
        this.listener.finish();
    }
}

