/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.FailureParser;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.TestResult;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultGenerator {
    private static String NEW_LINE = System.getProperty("line.separator");
    private final Gson gson = new Gson();

    public Collection<TestResult> getTestResults(Response response) {
        Collection collection = (Collection)this.gson.fromJson(response.getResponse(), new TypeToken<Collection<TestResult>>(){}.getType());
        for (TestResult testResult : collection) {
            BrowserInfo browserInfo = response.getBrowser();
            testResult.setBrowserInfo(browserInfo);
            FailureParser failureParser = new FailureParser();
            failureParser.parse(testResult.getMessage());
            testResult.setParsedMessage(failureParser.getMessage());
            List<String> list = failureParser.getStack();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : list) {
                stringBuilder.append(string);
                stringBuilder.append(NEW_LINE);
            }
            testResult.setStack(stringBuilder.toString());
        }
        return collection;
    }
}

