/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.PathResolver;
import com.google.jstestdriver.PathRewriter;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.config.ParsedConfiguration;
import com.google.jstestdriver.hooks.FileParsePostProcessor;
import java.io.File;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.oro.io.GlobFilenameFilter;
import org.jvyaml.YAML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlParser {
    private final PathRewriter pathRewriter;
    private final PathResolver pathResolver = new PathResolver();
    private final Set<FileParsePostProcessor> processors;

    public YamlParser(PathRewriter pathRewriter, Set<FileParsePostProcessor> set) {
        this.pathRewriter = pathRewriter;
        this.processors = set;
    }

    public Configuration parse(File file, Reader reader) {
        Map map = (Map)YAML.load(reader);
        LinkedHashSet<FileInfo> linkedHashSet = new LinkedHashSet<FileInfo>();
        LinkedHashSet<FileInfo> linkedHashSet2 = new LinkedHashSet<FileInfo>();
        String string = "";
        LinkedList<Plugin> linkedList = Lists.newLinkedList();
        LinkedHashSet<FileInfo> linkedHashSet3 = Sets.newLinkedHashSet();
        if (map.containsKey("load")) {
            linkedHashSet.addAll(this.resolveFiles(file, (List)map.get("load"), false));
        }
        if (map.containsKey("exclude")) {
            linkedHashSet2.addAll(this.resolveFiles(file, (List)map.get("exclude"), false));
        }
        if (map.containsKey("server")) {
            string = (String)map.get("server");
        }
        if (map.containsKey("plugin")) {
            for (Map map2 : (List)map.get("plugin")) {
                linkedList.add(new Plugin((String)map2.get("name"), (String)map2.get("jar"), (String)map2.get("module"), this.createArgsList((String)map2.get("args"))));
            }
        }
        if (map.containsKey("serve")) {
            Set<FileInfo> set = this.resolveFiles(file, (List)map.get("serve"), true);
            linkedHashSet.addAll((Collection<FileInfo>)set);
        }
        linkedHashSet3.addAll(this.consolidatePatches(linkedHashSet));
        linkedHashSet3.removeAll(linkedHashSet2);
        return new ParsedConfiguration(linkedHashSet3, linkedList, string);
    }

    private List<String> createArgsList(String string) {
        String[] stringArray;
        if (string == null) {
            return Collections.emptyList();
        }
        LinkedList<String> linkedList = Lists.newLinkedList();
        for (String string2 : stringArray = string.split(",")) {
            linkedList.add(string2.trim());
        }
        return linkedList;
    }

    private Set<FileInfo> consolidatePatches(Set<FileInfo> set) {
        LinkedHashSet<FileInfo> linkedHashSet = new LinkedHashSet<FileInfo>(set.size());
        FileInfo fileInfo = null;
        for (FileInfo fileInfo2 : set) {
            if (fileInfo2.isPatch()) {
                if (fileInfo == null) {
                    throw new IllegalStateException("Patch " + fileInfo2 + " without a core file to patch");
                }
                fileInfo.addPatch(fileInfo2);
                continue;
            }
            linkedHashSet.add(fileInfo2);
            fileInfo = fileInfo2;
        }
        return linkedHashSet;
    }

    /*
     * WARNING - void declaration
     */
    private Set<FileInfo> resolveFiles(File file, List<String> list, boolean bl) {
        if (list != null) {
            Set<FileInfo> set = new LinkedHashSet<FileInfo>();
            for (String string : list) {
                String string2;
                void object;
                Object object2;
                String string3 = this.pathRewriter.rewrite(string);
                boolean bl2 = string3.startsWith("patch");
                if (bl2) {
                    object2 = string3.split(" ", 2);
                    String string4 = object2[1].trim();
                }
                if (object.startsWith("http://") || object.startsWith("https://")) {
                    set.add(new FileInfo((String)object, -1L, false, false, null));
                    continue;
                }
                object2 = file != null ? new File(file.getAbsoluteFile(), (String)object) : new File((String)object);
                File file2 = ((File)object2).getAbsoluteFile();
                File file3 = file2.getParentFile().getAbsoluteFile();
                String[] stringArray = file3.list(new GlobFilenameFilter(string2 = ((File)object2).getName(), 1));
                if (stringArray == null || stringArray.length == 0) {
                    String string5 = "The patterns/paths " + (String)object + " used in the configuration" + " file didn't match any file, the files patterns/paths need to be relative to" + " the configuration file.";
                    System.err.println(string5);
                    throw new RuntimeException(string5);
                }
                Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
                for (String string6 : stringArray) {
                    String string7 = this.pathResolver.resolvePath(file3.getAbsolutePath().replaceAll("\\\\", "/") + "/" + string6.replaceAll("\\\\", "/"));
                    File file4 = new File(string7);
                    set.add(new FileInfo(string7, file4.lastModified(), bl2, bl, null));
                }
            }
            for (FileParsePostProcessor fileParsePostProcessor : this.processors) {
                set = fileParsePostProcessor.process(set);
            }
            return set;
        }
        return Collections.emptySet();
    }
}

