/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import com.google.inject.util.Types;
import com.google.jstestdriver.Flags;
import com.google.jstestdriver.guice.GuiceBinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

public class FlagBinder {
    private final Flags flags;

    public FlagBinder(Flags flags) {
        this.flags = flags;
    }

    public void bind(Binder binder) {
        for (Method method : Flags.class.getMethods()) {
            GuiceBinding guiceBinding = method.getAnnotation(GuiceBinding.class);
            if (guiceBinding == null) continue;
            try {
                Object object = method.invoke((Object)this.flags, new Object[0]);
                binder.bind(this.resolveClass(guiceBinding, method.getReturnType())).toProvider(Providers.of(object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
    }

    private Key resolveClass(GuiceBinding guiceBinding, Class clazz) {
        Named named = Names.named(guiceBinding.name());
        if (List.class.isAssignableFrom(clazz)) {
            if (guiceBinding.parameterizedType() == GuiceBinding.NullClass.class) {
                throw new IllegalArgumentException("Missing parameterized type for " + guiceBinding);
            }
            return Key.get((Type)Types.listOf(guiceBinding.parameterizedType()), (Annotation)named);
        }
        return Key.get(clazz, (Annotation)named);
    }
}

