/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.google.jstestdriver.DefaultResponseStreamFactory;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.output.DefaultListener;
import com.google.jstestdriver.output.MultiTestResultListener;
import com.google.jstestdriver.output.TestResultHolder;
import com.google.jstestdriver.output.TestResultListener;
import com.google.jstestdriver.output.XmlPrinter;
import com.google.jstestdriver.output.XmlPrinterImpl;
import java.io.PrintStream;

public class TestResultPrintingModule
extends AbstractModule {
    private final PrintStream out;
    private final String testOutput;

    public TestResultPrintingModule(PrintStream printStream, String string) {
        this.out = printStream;
        this.testOutput = string;
    }

    protected void configure() {
        this.bind(PrintStream.class).annotatedWith(Names.named("outputStream")).toInstance(this.out);
        Multibinder<TestResultListener> multibinder = Multibinder.newSetBinder(this.binder(), TestResultListener.class);
        if (this.testOutput.length() > 0) {
            multibinder.addBinding().to(TestResultHolder.class).in(Singleton.class);
        }
        multibinder.addBinding().to(DefaultListener.class).in(Singleton.class);
        this.bind(TestResultHolder.class).in(Singleton.class);
        this.bind(TestResultListener.class).to(MultiTestResultListener.class);
        Multibinder.newSetBinder(this.binder(), ResponseStreamFactory.class).addBinding().to(DefaultResponseStreamFactory.class);
        this.bind(XmlPrinter.class).to(XmlPrinterImpl.class);
    }
}

