/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.html;

import com.google.inject.Inject;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.hooks.FileLoadPostProcessor;
import com.google.jstestdriver.html.HtmlDocLexer;
import com.google.jstestdriver.html.HtmlDocParser;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;

public class InlineHtmlProcessor
implements FileLoadPostProcessor {
    private final HtmlDocParser parser;
    private final HtmlDocLexer lexer;

    @Inject
    public InlineHtmlProcessor(HtmlDocParser htmlDocParser, HtmlDocLexer htmlDocLexer) {
        this.parser = htmlDocParser;
        this.lexer = htmlDocLexer;
    }

    public FileInfo process(FileInfo fileInfo) {
        try {
            String string = fileInfo.getData();
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            this.parser.parse(this.lexer.createStream(new ByteArrayInputStream(string.getBytes()))).write(charArrayWriter);
            ((Writer)charArrayWriter).flush();
            return new FileInfo(fileInfo.getFileName(), fileInfo.getTimestamp(), fileInfo.isPatch(), fileInfo.isServeOnly(), ((Object)charArrayWriter).toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }
}

