/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.output;

import com.google.gson.Gson;
import com.google.jstestdriver.JsException;
import com.google.jstestdriver.TestResult;
import java.io.Writer;
import java.util.Collection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestXmlSerializer {
    private final Gson gson = new Gson();
    private final TransformerHandler transformerHandler;
    private final Writer fileWriter;

    public TestXmlSerializer(Writer writer) {
        try {
            this.transformerHandler = ((SAXTransformerFactory)SAXTransformerFactory.newInstance()).newTransformerHandler();
            Transformer transformer = this.transformerHandler.getTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            this.transformerHandler.setResult(new StreamResult(writer));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException(transformerConfigurationException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new RuntimeException(transformerFactoryConfigurationError);
        }
        this.fileWriter = writer;
    }

    private void startTestSuite(String string, SuiteAggregator suiteAggregator) {
        try {
            this.transformerHandler.startDocument();
            AttributesImpl attributesImpl = new AttributesImpl();
            if (string.trim().length() > 0) {
                attributesImpl.addAttribute("", "", "name", "CDATA", string);
                attributesImpl.addAttribute("", "", "errors", "CDATA", String.valueOf(suiteAggregator.error));
                attributesImpl.addAttribute("", "", "failures", "CDATA", String.valueOf(suiteAggregator.failed));
                attributesImpl.addAttribute("", "", "tests", "CDATA", String.valueOf(suiteAggregator.tests));
                attributesImpl.addAttribute("", "", "time", "CDATA", String.valueOf(suiteAggregator.elapsedTime));
            }
            this.transformerHandler.startElement("", "", "testsuite", attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
    }

    private void endTestSuite() {
        try {
            this.transformerHandler.endElement("", "", "testsuite");
            this.transformerHandler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
    }

    private void startTestCase(String string, String string2, float f) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", "classname", "CDATA", string);
        attributesImpl.addAttribute("", "", "name", "CDATA", string2);
        attributesImpl.addAttribute("", "", "time", "CDATA", Float.toString(f / 1000.0f));
        try {
            this.transformerHandler.startElement("", "", "testcase", attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
    }

    private void endTestCase() {
        try {
            this.transformerHandler.endElement("", "", "testcase");
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
    }

    private void addFailure(String string, String string2) {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "", "type", "CDATA", "failed");
            attributesImpl.addAttribute("", "", "message", "CDATA", string2);
            this.transformerHandler.startElement("", "", "failure", attributesImpl);
            char[] cArray = string.toCharArray();
            this.transformerHandler.characters(cArray, 0, cArray.length);
            this.transformerHandler.endElement("", "", "failure");
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
    }

    private void addError(String string) {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "", "type", "CDATA", "error");
            this.transformerHandler.startElement("", "", "error", attributesImpl);
            char[] cArray = string.toCharArray();
            this.transformerHandler.characters(cArray, 0, cArray.length);
            this.transformerHandler.endElement("", "", "error");
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
    }

    private void addOutput(String string) {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            this.transformerHandler.startElement("", "", "system-out", attributesImpl);
            char[] cArray = string.toCharArray();
            this.transformerHandler.startCDATA();
            this.transformerHandler.characters(cArray, 0, cArray.length);
            this.transformerHandler.endCDATA();
            this.transformerHandler.endElement("", "", "system-out");
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
    }

    public void writeTestCase(String string, Collection<TestResult> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        SuiteAggregator suiteAggregator = new SuiteAggregator(collection).aggregate();
        this.startTestSuite(string, suiteAggregator);
        for (TestResult testResult : collection) {
            this.startTestCase(string, testResult.getTestName(), testResult.getTime());
            if (testResult.getResult() != TestResult.Result.passed) {
                String string2;
                try {
                    JsException jsException = this.gson.fromJson(testResult.getMessage(), JsException.class);
                    string2 = jsException.getMessage();
                }
                catch (Exception exception) {
                    string2 = testResult.getMessage();
                }
                if (testResult.getResult() == TestResult.Result.failed) {
                    this.addFailure(testResult.getStack(), string2);
                } else if (testResult.getResult() == TestResult.Result.error) {
                    this.addError(string2);
                }
            }
            stringBuilder.append(testResult.getLog());
            this.endTestCase();
        }
        if (stringBuilder.length() > 0) {
            this.addOutput(stringBuilder.toString());
        }
        this.endTestSuite();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SuiteAggregator {
        int tests = 0;
        int failed = 0;
        int error = 0;
        float elapsedTime = 0.0f;
        private final Collection<TestResult> results;
        private boolean topLevel = false;

        public SuiteAggregator(Collection<TestResult> collection) {
            this.results = collection;
        }

        public SuiteAggregator aggregate() {
            for (TestResult testResult : this.results) {
                ++this.tests;
                this.failed += testResult.getResult() == TestResult.Result.failed ? 1 : 0;
                this.error += testResult.getResult() == TestResult.Result.error ? 1 : 0;
                this.elapsedTime += testResult.getTime() / 1000.0f;
            }
            return this;
        }
    }
}

