/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.output;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.output.TestResultHolder;
import com.google.jstestdriver.output.TestXmlSerializer;
import com.google.jstestdriver.output.XmlPrinter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlPrinterImpl
implements XmlPrinter {
    private final Logger logger = LoggerFactory.getLogger(XmlPrinterImpl.class);
    private final TestResultHolder resultHolder;
    private final String xmlOutputDir;
    private final String fileNameFormat = "TEST-%s.xml";

    @Inject
    public XmlPrinterImpl(TestResultHolder testResultHolder, @Named(value="testOutput") String string) {
        this.resultHolder = testResultHolder;
        this.xmlOutputDir = string;
    }

    @Override
    public void writeXmlReportFiles() {
        Map<BrowserInfo, String> map = XmlPrinterImpl.createUniqueBrowserNames(this.resultHolder.getResults().keySet());
        for (BrowserInfo browserInfo : this.resultHolder.getResults().keySet()) {
            Multimap<String, TestResult> multimap = this.newMultiMap();
            for (TestResult testResult : this.resultHolder.getResults().get(browserInfo)) {
                multimap.put(testResult.getTestCaseName(), testResult);
            }
            for (String string : multimap.keySet()) {
                String string2 = this.formatSuiteName(map.get(browserInfo), string);
                File file = new File(this.xmlOutputDir, this.formatFileName(string2));
                try {
                    file.createNewFile();
                    TestXmlSerializer testXmlSerializer = new TestXmlSerializer(new FileWriter(file));
                    testXmlSerializer.writeTestCase(string2, multimap.get(string));
                }
                catch (IOException iOException) {
                    this.logger.error("Could not create file: {}", (Object)file.getAbsolutePath(), (Object)iOException);
                }
            }
        }
    }

    public static Map<BrowserInfo, String> createUniqueBrowserNames(Set<BrowserInfo> set) {
        HashMap<BrowserInfo, String> hashMap = Maps.newHashMap();
        for (BrowserInfo browserInfo : set) {
            if (hashMap.containsValue(browserInfo.toString())) {
                hashMap.put(browserInfo, browserInfo.toUniqueString());
                continue;
            }
            hashMap.put(browserInfo, browserInfo.toString());
        }
        return hashMap;
    }

    private String formatFileName(String string) {
        return String.format("TEST-%s.xml", string);
    }

    private String formatSuiteName(String string, String string2) {
        return String.format("%s.%s", string.replaceAll("\\s", "_").replaceAll("\\.", ""), string2);
    }

    private Multimap<String, TestResult> newMultiMap() {
        return Multimaps.newMultimap(Maps.newHashMap(), new Supplier<Collection<TestResult>>(){

            @Override
            public Collection<TestResult> get() {
                return Lists.newLinkedList();
            }
        });
    }
}

