/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.token;

import com.google.common.collect.Maps;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EscapingWriter
extends FilterWriter {
    private static final Map<Character, char[]> REPLACE;
    private final char[] escapedBuffer = new char[256];

    public EscapingWriter(Writer writer) {
        super(writer);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 = REPLACE.containsKey(Character.valueOf(cArray[i])) ? this.writeToBuffer(n3, REPLACE.get(Character.valueOf(cArray[i]))) : this.writeToBuffer(n3, cArray[i]);
        }
        this.out.write(this.escapedBuffer, 0, n3);
    }

    private int writeToBuffer(int n, char c) throws IOException {
        if (n + 1 > this.escapedBuffer.length) {
            this.out.write(this.escapedBuffer, 0, n);
            n = 0;
        }
        this.escapedBuffer[n++] = c;
        return n;
    }

    private int writeToBuffer(int n, char[] cArray) throws IOException {
        if (n + cArray.length > this.escapedBuffer.length) {
            this.out.write(this.escapedBuffer, 0, n);
            n = 0;
        }
        System.arraycopy(cArray, 0, this.escapedBuffer, 0, n);
        return n += cArray.length;
    }

    public void write(int n) throws IOException {
        Character c = Character.valueOf((char)n);
        if (REPLACE.containsKey(c)) {
            this.out.write(REPLACE.get(c));
        } else {
            this.out.write(n);
        }
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    static {
        HashMap<Character, char[]> hashMap = Maps.newHashMap();
        hashMap.put(Character.valueOf('\\'), new char[]{'\\', '\\'});
        hashMap.put(Character.valueOf('\n'), new char[]{'\\', 'n'});
        hashMap.put(Character.valueOf('\r'), new char[]{'\\', 'r'});
        hashMap.put(Character.valueOf('\f'), new char[]{'\\', 'f'});
        hashMap.put(Character.valueOf('\''), new char[]{'\\', '\''});
        hashMap.put(Character.valueOf('\"'), new char[]{'\\', '\"'});
        REPLACE = Collections.unmodifiableMap(hashMap);
    }
}

