/*
 * Decompiled with CFR 0.152.
 */
package org.jvyaml;

import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jvyaml.Composer;
import org.jvyaml.ComposerImpl;
import org.jvyaml.Constructor;
import org.jvyaml.ConstructorException;
import org.jvyaml.ParserImpl;
import org.jvyaml.PrivateType;
import org.jvyaml.ResolverImpl;
import org.jvyaml.ScannerImpl;
import org.jvyaml.nodes.MappingNode;
import org.jvyaml.nodes.Node;
import org.jvyaml.nodes.ScalarNode;
import org.jvyaml.nodes.SequenceNode;

public class BaseConstructorImpl
implements Constructor {
    private static final Map yamlConstructors = new HashMap();
    private static final Map yamlMultiConstructors = new HashMap();
    private static final Map yamlMultiRegexps = new HashMap();
    private Composer composer;
    private Map constructedObjects = new HashMap();
    private Map recursiveObjects = new HashMap();
    public static final Constructor.YamlConstructor CONSTRUCT_PRIMITIVE = new Constructor.YamlConstructor(){

        public Object call(Constructor self, Node node) {
            return self.constructPrimitive(node);
        }
    };
    public static final Constructor.YamlConstructor CONSTRUCT_SCALAR = new Constructor.YamlConstructor(){

        public Object call(Constructor self, Node node) {
            return self.constructScalar(node);
        }
    };
    public static final Constructor.YamlConstructor CONSTRUCT_PRIVATE = new Constructor.YamlConstructor(){

        public Object call(Constructor self, Node node) {
            return self.constructPrivateType(node);
        }
    };
    public static final Constructor.YamlConstructor CONSTRUCT_SEQUENCE = new Constructor.YamlConstructor(){

        public Object call(Constructor self, Node node) {
            return self.constructSequence(node);
        }
    };
    public static final Constructor.YamlConstructor CONSTRUCT_MAPPING = new Constructor.YamlConstructor(){

        public Object call(Constructor self, Node node) {
            return self.constructMapping(node);
        }
    };

    public Constructor.YamlConstructor getYamlConstructor(Object key) {
        return (Constructor.YamlConstructor)yamlConstructors.get(key);
    }

    public Constructor.YamlMultiConstructor getYamlMultiConstructor(Object key) {
        return (Constructor.YamlMultiConstructor)yamlMultiConstructors.get(key);
    }

    public Pattern getYamlMultiRegexp(Object key) {
        return (Pattern)yamlMultiRegexps.get(key);
    }

    public Set getYamlMultiRegexps() {
        return yamlMultiRegexps.keySet();
    }

    public static void addConstructor(String tag, Constructor.YamlConstructor ctor) {
        yamlConstructors.put(tag, ctor);
    }

    public static void addMultiConstructor(String tagPrefix, Constructor.YamlMultiConstructor ctor) {
        yamlMultiConstructors.put(tagPrefix, ctor);
        yamlMultiRegexps.put(tagPrefix, Pattern.compile("^" + tagPrefix));
    }

    public BaseConstructorImpl(Composer composer) {
        this.composer = composer;
    }

    public boolean checkData() {
        return this.composer.checkNode();
    }

    public Object getData() {
        Node node;
        if (this.composer.checkNode() && null != (node = this.composer.getNode())) {
            return this.constructDocument(node);
        }
        return null;
    }

    public Iterator eachDocument() {
        return new DocumentIterator();
    }

    public Iterator iterator() {
        return this.eachDocument();
    }

    public Object constructDocument(Node node) {
        Object data = this.constructObject(node);
        this.constructedObjects.clear();
        this.recursiveObjects.clear();
        return data;
    }

    public Object constructObject(Node node) {
        if (this.constructedObjects.containsKey(node)) {
            return this.constructedObjects.get(node);
        }
        if (this.recursiveObjects.containsKey(node)) {
            throw new ConstructorException(null, "found recursive node", null);
        }
        this.recursiveObjects.put(node, null);
        Constructor.YamlConstructor ctor = this.getYamlConstructor(node.getTag());
        if (ctor == null) {
            boolean through = true;
            Iterator iter = this.getYamlMultiRegexps().iterator();
            while (iter.hasNext()) {
                String tagPrefix = (String)iter.next();
                Pattern reg = this.getYamlMultiRegexp(tagPrefix);
                if (!reg.matcher(node.getTag()).find()) continue;
                String tagSuffix = node.getTag().substring(tagPrefix.length());
                ctor = new YamlMultiAdapter(this.getYamlMultiConstructor(tagPrefix), tagSuffix);
                through = false;
                break;
            }
            if (through) {
                Constructor.YamlMultiConstructor xctor = this.getYamlMultiConstructor(null);
                if (null != xctor) {
                    ctor = new YamlMultiAdapter(xctor, node.getTag());
                } else {
                    ctor = this.getYamlConstructor(null);
                    if (ctor == null) {
                        ctor = CONSTRUCT_PRIMITIVE;
                    }
                }
            }
        }
        Object data = ctor.call(this, node);
        this.constructedObjects.put(node, data);
        this.recursiveObjects.remove(node);
        return data;
    }

    public Object constructPrimitive(Node node) {
        if (node instanceof ScalarNode) {
            return this.constructScalar(node);
        }
        if (node instanceof SequenceNode) {
            return this.constructSequence(node);
        }
        if (node instanceof MappingNode) {
            return this.constructMapping(node);
        }
        System.err.println(node.getTag());
        return null;
    }

    public Object constructScalar(Node node) {
        if (!(node instanceof ScalarNode)) {
            if (node instanceof MappingNode) {
                Map vals = (Map)node.getValue();
                Iterator iter = vals.keySet().iterator();
                while (iter.hasNext()) {
                    Node key = (Node)iter.next();
                    if (!"tag:yaml.org,2002:value".equals(key.getTag())) continue;
                    return this.constructScalar((Node)vals.get(key));
                }
            }
            throw new ConstructorException(null, "expected a scalar node, but found " + node.getClass().getName(), null);
        }
        return node.getValue();
    }

    public Object constructPrivateType(Node node) {
        Object val = null;
        val = node.getValue() instanceof Map ? this.constructMapping(node) : (node.getValue() instanceof List ? this.constructSequence(node) : node.getValue().toString());
        return new PrivateType(node.getTag(), val);
    }

    public Object constructSequence(Node node) {
        if (!(node instanceof SequenceNode)) {
            throw new ConstructorException(null, "expected a sequence node, but found " + node.getClass().getName(), null);
        }
        List internal = (List)node.getValue();
        ArrayList<Object> val = new ArrayList<Object>(internal.size());
        Iterator iter = internal.iterator();
        while (iter.hasNext()) {
            val.add(this.constructObject((Node)iter.next()));
        }
        return val;
    }

    public Object constructMapping(Node node) {
        if (!(node instanceof MappingNode)) {
            throw new ConstructorException(null, "expected a mapping node, but found " + node.getClass().getName(), null);
        }
        HashMap<Object, Object> mapping = new HashMap<Object, Object>();
        LinkedList<HashMap<Object, Object>> merge = null;
        Map val = (Map)node.getValue();
        Iterator<Object> iter = val.keySet().iterator();
        while (iter.hasNext()) {
            Node key_v = (Node)iter.next();
            Node value_v = (Node)val.get(key_v);
            if (key_v.getTag().equals("tag:yaml.org,2002:merge")) {
                if (merge != null) {
                    throw new ConstructorException("while constructing a mapping", "found duplicate merge key", null);
                }
                if (value_v instanceof MappingNode) {
                    merge = new LinkedList<HashMap<Object, Object>>();
                    merge.add((HashMap<Object, Object>)this.constructMapping(value_v));
                    continue;
                }
                if (value_v instanceof SequenceNode) {
                    merge = new LinkedList();
                    List vals = (List)value_v.getValue();
                    Iterator sub = vals.iterator();
                    while (sub.hasNext()) {
                        Node subnode = (Node)sub.next();
                        if (!(subnode instanceof MappingNode)) {
                            throw new ConstructorException("while constructing a mapping", "expected a mapping for merging, but found " + subnode.getClass().getName(), null);
                        }
                        merge.add(0, (HashMap<Object, Object>)this.constructMapping(subnode));
                    }
                    continue;
                }
                throw new ConstructorException("while constructing a mapping", "expected a mapping or list of mappings for merging, but found " + value_v.getClass().getName(), null);
            }
            if (key_v.getTag().equals("tag:yaml.org,2002:value")) {
                if (mapping.containsKey("=")) {
                    throw new ConstructorException("while construction a mapping", "found duplicate value key", null);
                }
                mapping.put("=", this.constructObject(value_v));
                continue;
            }
            mapping.put(this.constructObject(key_v), this.constructObject(value_v));
        }
        if (null != merge) {
            merge.add(mapping);
            mapping = new HashMap();
            iter = merge.iterator();
            while (iter.hasNext()) {
                mapping.putAll((Map)iter.next());
            }
        }
        return mapping;
    }

    public Object constructPairs(Node node) {
        if (!(node instanceof MappingNode)) {
            throw new ConstructorException(null, "expected a mapping node, but found " + node.getClass().getName(), null);
        }
        LinkedList<Object[]> value = new LinkedList<Object[]>();
        Map vals = (Map)node.getValue();
        Iterator iter = vals.keySet().iterator();
        while (iter.hasNext()) {
            Node key = (Node)iter.next();
            Node val = (Node)vals.get(key);
            value.add(new Object[]{this.constructObject(key), this.constructObject(val)});
        }
        return value;
    }

    public static void main(String[] args) throws Exception {
        String filename = args[0];
        System.out.println("Reading of file: \"" + filename + "\"");
        StringBuffer input = new StringBuffer();
        FileReader reader = new FileReader(filename);
        char[] buff = new char[1024];
        int read = 0;
        do {
            read = reader.read(buff);
            input.append(buff, 0, read);
        } while (read >= 1024);
        ((Reader)reader).close();
        String str = input.toString();
        BaseConstructorImpl ctor = new BaseConstructorImpl(new ComposerImpl(new ParserImpl(new ScannerImpl(str)), new ResolverImpl()));
        Iterator iter = ctor.eachDocument();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }

    public static class YamlMultiAdapter
    implements Constructor.YamlConstructor {
        private Constructor.YamlMultiConstructor ctor;
        private String prefix;

        public YamlMultiAdapter(Constructor.YamlMultiConstructor ctor, String prefix) {
            this.ctor = ctor;
            this.prefix = prefix;
        }

        public Object call(Constructor self, Node node) {
            return this.ctor.call(self, this.prefix, node);
        }
    }

    private class DocumentIterator
    implements Iterator {
        private DocumentIterator() {
        }

        public boolean hasNext() {
            return BaseConstructorImpl.this.checkData();
        }

        public Object next() {
            return BaseConstructorImpl.this.getData();
        }

        public void remove() {
        }
    }
}

