/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.google.jstestdriver.DryRunAction;
import com.google.jstestdriver.EvalAction;
import com.google.jstestdriver.FailureAccumulator;
import com.google.jstestdriver.ResetAction;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.RunTestsActionResponseStream;
import com.google.jstestdriver.TestResultGenerator;
import com.google.jstestdriver.output.TestResultListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResponseStreamFactory
implements ResponseStreamFactory {
    private final Provider<TestResultListener> responsePrinterFactory;
    private final String configFileName;
    private final FailureAccumulator accumulator;

    @Inject
    public DefaultResponseStreamFactory(Provider<TestResultListener> provider, @Named(value="config") String string, FailureAccumulator failureAccumulator) {
        this.responsePrinterFactory = provider;
        this.configFileName = string;
        this.accumulator = failureAccumulator;
    }

    @Override
    public ResponseStream getRunTestsActionResponseStream(String string) {
        String string2 = String.format("com.google.jstestdriver.%s", string);
        TestResultListener testResultListener = this.responsePrinterFactory.get();
        RunTestsActionResponseStream runTestsActionResponseStream = new RunTestsActionResponseStream(new TestResultGenerator(), testResultListener, this.accumulator);
        return runTestsActionResponseStream;
    }

    @Override
    public ResponseStream getDryRunActionResponseStream() {
        return new DryRunAction.DryRunActionResponseStream();
    }

    @Override
    public ResponseStream getEvalActionResponseStream() {
        return new EvalAction.EvalActionResponseStream();
    }

    @Override
    public ResponseStream getResetActionResponseStream() {
        return new ResetAction.ResetActionResponseStream();
    }
}

