/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.CommandTask;
import com.google.jstestdriver.CommandTaskFactory;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.Server;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class JsTestDriverClientImpl
implements JsTestDriverClient {
    private final Gson gson = new Gson();
    private final CommandTaskFactory commandTaskFactory;
    private final Set<FileInfo> fileSet;
    private final String baseUrl;
    private final Server server;

    @Inject
    public JsTestDriverClientImpl(CommandTaskFactory commandTaskFactory, @Named(value="fileSet") Set<FileInfo> set, @Named(value="server") String string, Server server) {
        this.commandTaskFactory = commandTaskFactory;
        this.fileSet = set;
        this.baseUrl = string;
        this.server = server;
    }

    @Override
    public Collection<BrowserInfo> listBrowsers() {
        return (Collection)this.gson.fromJson(this.server.fetch(this.baseUrl + "/cmd?listBrowsers"), new TypeToken<Collection<BrowserInfo>>(){}.getType());
    }

    private void sendCommand(String string, ResponseStream responseStream, String string2, boolean bl) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("data", string2);
        linkedHashMap.put("id", string);
        CommandTask commandTask = this.commandTaskFactory.getCommandTask(responseStream, this.fileSet, this.baseUrl, this.server, linkedHashMap, bl);
        commandTask.run();
    }

    @Override
    public void eval(String string, ResponseStream responseStream, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string2);
        JsonCommand jsonCommand = new JsonCommand(JsonCommand.CommandType.EXECUTE, linkedList);
        this.sendCommand(string, responseStream, this.gson.toJson(jsonCommand), false);
    }

    @Override
    public void runAllTests(String string, ResponseStream responseStream, boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(String.valueOf(bl));
        linkedList.add("false");
        JsonCommand jsonCommand = new JsonCommand(JsonCommand.CommandType.RUNALLTESTS, linkedList);
        this.sendCommand(string, responseStream, this.gson.toJson(jsonCommand), true);
    }

    @Override
    public void reset(String string, ResponseStream responseStream) {
        JsonCommand jsonCommand = new JsonCommand(JsonCommand.CommandType.RESET, Collections.<String>emptyList());
        this.sendCommand(string, responseStream, this.gson.toJson(jsonCommand), false);
    }

    @Override
    public void runTests(String string, ResponseStream responseStream, List<String> list, boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this.gson.toJson(list));
        linkedList.add(String.valueOf(bl));
        JsonCommand jsonCommand = new JsonCommand(JsonCommand.CommandType.RUNTESTS, linkedList);
        this.sendCommand(string, responseStream, this.gson.toJson(jsonCommand), true);
    }

    @Override
    public void dryRun(String string, ResponseStream responseStream) {
        JsonCommand jsonCommand = new JsonCommand(JsonCommand.CommandType.DRYRUN, Collections.<String>emptyList());
        this.sendCommand(string, responseStream, this.gson.toJson(jsonCommand), true);
    }

    @Override
    public void dryRunFor(String string, ResponseStream responseStream, List<String> list) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this.gson.toJson(list));
        JsonCommand jsonCommand = new JsonCommand(JsonCommand.CommandType.DRYRUNFOR, linkedList);
        this.sendCommand(string, responseStream, this.gson.toJson(jsonCommand), true);
    }
}

