/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.HeartBeatManager;
import com.google.jstestdriver.JsTestDriverFileFilter;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.LoadedFiles;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.Server;
import com.google.jstestdriver.StreamMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandTask.class);
    private static final List<String> EMPTY_ARRAYLIST = new ArrayList<String>();
    private static final long WAIT_INTERVAL = 500L;
    public static final int CHUNK_SIZE = 150;
    private final Gson gson = new Gson();
    private final JsTestDriverFileFilter filter;
    private final ResponseStream stream;
    private final Set<FileInfo> fileSet;
    private final String baseUrl;
    private final Server server;
    private final Map<String, String> params;
    private final HeartBeatManager heartBeatManager;
    private final FileLoader fileLoader;
    private final boolean upload;

    public CommandTask(JsTestDriverFileFilter jsTestDriverFileFilter, ResponseStream responseStream, Set<FileInfo> set, String string, Server server, Map<String, String> map, HeartBeatManager heartBeatManager, FileLoader fileLoader, boolean bl) {
        this.filter = jsTestDriverFileFilter;
        this.stream = responseStream;
        this.fileSet = set;
        this.baseUrl = string;
        this.server = server;
        this.params = map;
        this.heartBeatManager = heartBeatManager;
        this.fileLoader = fileLoader;
        this.upload = bl;
    }

    private String startSession() {
        String string = this.params.get("id");
        String string2 = this.server.startSession(this.baseUrl, string);
        if (string2.equals("FAILED")) {
            while (string2.equals("FAILED")) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Could not create session for browser: " + string);
                    return "";
                }
                string2 = this.server.startSession(this.baseUrl, string);
            }
        }
        return string2;
    }

    private void stopSession(String string) {
        this.server.stopSession(this.baseUrl, this.params.get("id"), string);
    }

    private boolean isBrowserAlive() {
        String string = this.server.fetch(this.baseUrl + "/heartbeat?id=" + this.params.get("id"));
        if (!string.equals("OK")) {
            System.err.println("The browser " + this.params.get("id") + " is not available anymore, " + "you might want to re-capture it");
            return false;
        }
        return true;
    }

    public static FileSource fileInfoToFileSource(FileInfo fileInfo) {
        if (fileInfo.getFileName().startsWith("http://")) {
            return new FileSource(fileInfo.getFileName(), fileInfo.getTimestamp());
        }
        return new FileSource("/test/" + fileInfo.getFileName(), fileInfo.getTimestamp());
    }

    private void shouldPanic(String string) {
        if (string.startsWith("PANIC:")) {
            LOGGER.error(string);
            throw new RuntimeException(string);
        }
    }

    private void uploadFileSet() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", this.params.get("id"));
        linkedHashMap.put("fileSet", this.gson.toJson(this.fileSet));
        String string = this.server.post(this.baseUrl + "/fileSet", linkedHashMap);
        if (string.length() > 0) {
            Object object;
            LinkedHashMap<String, String> linkedHashMap22;
            List<FileInfo> list;
            Collection collection = (Collection)this.gson.fromJson(string, new TypeToken<Collection<FileInfo>>(){}.getType());
            boolean bl = this.sameFiles(collection, this.fileSet);
            LinkedHashSet<FileInfo> linkedHashSet = new LinkedHashSet<FileInfo>();
            if (bl) {
                list = new JsonCommand(JsonCommand.CommandType.RESET, EMPTY_ARRAYLIST);
                linkedHashMap22 = new LinkedHashMap();
                linkedHashMap22.put("id", this.params.get("id"));
                linkedHashMap22.put("data", this.gson.toJson(list));
                this.server.post(this.baseUrl + "/cmd", linkedHashMap22);
                object = this.server.fetch(this.baseUrl + "/cmd?id=" + this.params.get("id"));
                StreamMessage streamMessage = this.gson.fromJson((String)object, StreamMessage.class);
                Response response = streamMessage.getResponse();
                this.shouldPanic(response.getResponse());
                linkedHashSet.addAll(collection);
            } else {
                for (LinkedHashMap<String, String> linkedHashMap22 : collection) {
                    linkedHashSet.addAll(this.findDependencies((FileInfo)((Object)linkedHashMap22)));
                }
            }
            list = this.fileLoader.loadFiles(linkedHashSet, bl);
            linkedHashMap22 = new LinkedHashMap<String, String>();
            linkedHashMap22.put("id", this.params.get("id"));
            linkedHashMap22.put("data", this.gson.toJson(list));
            this.server.post(this.baseUrl + "/fileSet", linkedHashMap22);
            object = new LinkedList<FileSource>(this.filterFilesToLoad(list));
            int n = object.size();
            for (int i = 0; i < n; i += 150) {
                int n2 = Math.min(i + 150, n);
                LinkedList<String> linkedList = new LinkedList<String>();
                List list2 = object.subList(i, n2);
                linkedList.add(this.gson.toJson(list2));
                linkedList.add("false");
                JsonCommand jsonCommand = new JsonCommand(JsonCommand.CommandType.LOADTEST, linkedList);
                LinkedHashMap<String, String> linkedHashMap3 = new LinkedHashMap<String, String>();
                linkedHashMap3.put("id", this.params.get("id"));
                linkedHashMap3.put("data", this.gson.toJson(jsonCommand));
                this.server.post(this.baseUrl + "/cmd", linkedHashMap3);
                String string2 = this.server.fetch(this.baseUrl + "/cmd?id=" + this.params.get("id"));
                StreamMessage streamMessage = this.gson.fromJson(string2, StreamMessage.class);
                Response response = streamMessage.getResponse();
                if (response.getResponse().startsWith("PANIC:")) {
                    throw new RuntimeException(response.getResponse());
                }
                LoadedFiles loadedFiles = this.gson.fromJson(response.getResponse(), LoadedFiles.class);
                if (loadedFiles.getLoadedFiles().isEmpty()) {
                    System.err.println("No files were loaded.");
                    continue;
                }
                if (!loadedFiles.hasError()) continue;
                for (FileResult fileResult : loadedFiles.getLoadedFiles()) {
                    if (fileResult.isSuccess()) continue;
                    System.err.println(fileResult.getMessage());
                }
            }
        }
    }

    private Collection<FileInfo> findDependencies(FileInfo fileInfo) {
        LinkedList<FileInfo> linkedList = new LinkedList<FileInfo>();
        for (String string : this.filter.resolveFilesDeps(fileInfo.getFileName())) {
            linkedList.add(new FileInfo(string, new File(string).lastModified(), false, false, null));
        }
        return linkedList;
    }

    private List<FileSource> filterFilesToLoad(Collection<FileInfo> collection) {
        LinkedList<FileSource> linkedList = new LinkedList<FileSource>();
        for (FileInfo fileInfo : collection) {
            if (fileInfo.isServeOnly()) continue;
            linkedList.add(CommandTask.fileInfoToFileSource(fileInfo));
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.heartBeatManager.startTimer();
        String string = this.params.get("id");
        String string2 = null;
        try {
            string2 = this.startSession();
            if (!string2.equals("")) {
                this.heartBeatManager.startHeartBeat(this.baseUrl, string, string2);
            }
            if (!this.isBrowserAlive()) {
                return;
            }
            if (this.upload) {
                this.uploadFileSet();
            }
            this.server.post(this.baseUrl + "/cmd", this.params);
            StreamMessage streamMessage = null;
            do {
                String string3 = this.server.fetch(this.baseUrl + "/cmd?id=" + string);
                streamMessage = this.gson.fromJson(string3, StreamMessage.class);
                Response response = streamMessage.getResponse();
                this.shouldPanic(response.getResponse());
                this.stream.stream(response);
            } while (streamMessage != null && !streamMessage.isLast());
        }
        finally {
            this.stream.finish();
            this.heartBeatManager.cancelTimer();
            this.stopSession(string2);
        }
    }

    private boolean sameFiles(Collection<FileInfo> collection, Collection<FileInfo> collection2) {
        for (FileInfo fileInfo : collection2) {
            if (fileInfo.isServeOnly() || collection.contains(fileInfo)) continue;
            return false;
        }
        return true;
    }
}

