/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.ForwardingMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.servlet.ProxyServlet;

public class ForwardingServlet
extends ProxyServlet.Transparent {
    private static final int SKIP_FORWARD_INDEX = "/forward".length();
    private static final ThreadLocal<String> threadLocalReferrer = new ThreadLocal();
    private final ForwardingMapper forwardingMapper;

    public ForwardingServlet(ForwardingMapper forwardingMapper, String string, int n) {
        super("forward", string, n);
        this.forwardingMapper = forwardingMapper;
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        try {
            threadLocalReferrer.set(httpServletRequest.getHeader("Referer"));
            super.service(servletRequest, servletResponse);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to forward " + httpServletRequest.getRequestURI(), exception);
        }
        finally {
            threadLocalReferrer.remove();
        }
    }

    protected URL proxyHttpURL(String string, String string2, int n, String string3) throws MalformedURLException {
        return this.getForwardingUrl(string, string2, n, string3, threadLocalReferrer.get());
    }

    public URL getForwardingUrl(String string, String string2, int n, String string3, String string4) throws MalformedURLException {
        String string5 = this.forwardingMapper.getForwardTo(string3);
        if (string5 != null) {
            return new URL(string5);
        }
        string3 = string3.substring(SKIP_FORWARD_INDEX);
        if (string4 != null && string4.startsWith("/forward")) {
            string4 = string4.substring(SKIP_FORWARD_INDEX);
        }
        String string6 = String.format("%s://%s:%d%s", string, string2, n, string3);
        URL uRL = new URL(string4);
        string5 = this.forwardingMapper.getForwardTo(uRL.getPath());
        if (string5 != null) {
            URL uRL2 = new URL(string5);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(uRL2.getProtocol());
            stringBuilder.append("://");
            stringBuilder.append(uRL2.getHost());
            int n2 = uRL2.getPort();
            if (n2 != -1) {
                stringBuilder.append(":");
                stringBuilder.append(Integer.toString(n2));
            }
            String string7 = stringBuilder.toString();
            String string8 = string7 + string3;
            this.forwardingMapper.addForwardingMapping(string6, string7);
            return new URL(string8);
        }
        String string9 = this.forwardingMapper.getForwardTo(string4);
        this.forwardingMapper.addForwardingMapping(string6, string9);
        return new URL(string9 + string3);
    }
}

