/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.jstestdriver.BrowserHunter;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.SlaveResourceService;
import com.google.jstestdriver.SlaveResourceServlet;
import com.google.jstestdriver.StandaloneRunnerFilesFilter;
import com.google.jstestdriver.UserAgentParser;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StandaloneRunnerServlet
extends HttpServlet {
    private static final long serialVersionUID = 8525889760512657635L;
    private final Gson gson = new Gson();
    private final BrowserHunter browserHunter;
    private final FilesCache cache;
    private final StandaloneRunnerFilesFilter filter;
    private final SlaveResourceService service;
    private static final Pattern ID = Pattern.compile("/(\\d+)/.*");

    public StandaloneRunnerServlet(BrowserHunter browserHunter, FilesCache filesCache, StandaloneRunnerFilesFilter standaloneRunnerFilesFilter, SlaveResourceService slaveResourceService) {
        this.browserHunter = browserHunter;
        this.cache = filesCache;
        this.filter = standaloneRunnerFilesFilter;
        this.service = slaveResourceService;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = SlaveResourceServlet.stripId(httpServletRequest.getPathInfo());
        String string2 = StandaloneRunnerServlet.getIdFromUrl(httpServletRequest.getPathInfo());
        if (httpServletRequest.getPathInfo().endsWith("RemoteConsoleRunnerquirks.html") || httpServletRequest.getPathInfo().endsWith("RemoteConsoleRunnerstrict.html")) {
            if (this.browserHunter.isBrowserCaptured(string2)) {
                this.browserHunter.freeBrowser(string2);
            }
            this.service(httpServletRequest.getHeader("User-Agent"), string, string2);
        }
        this.service.serve(string, httpServletResponse.getOutputStream());
    }

    public static String getIdFromUrl(String string) {
        Matcher matcher = ID.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException(string);
    }

    public void service(String string, String string2, String string3) {
        UserAgentParser userAgentParser = new UserAgentParser();
        userAgentParser.parse(string);
        SlaveBrowser slaveBrowser = this.browserHunter.captureBrowser(string3, userAgentParser.getName(), userAgentParser.getVersion(), userAgentParser.getOs());
        Set<String> set = this.filter.filter(string2, this.cache);
        LinkedList<FileSource> linkedList = new LinkedList<FileSource>();
        for (String string4 : set) {
            linkedList.add(new FileSource("/test/" + string4, -1L));
        }
        int n = linkedList.size();
        for (int i = 0; i < n; i += 150) {
            LinkedList<String> linkedList2 = new LinkedList<String>();
            List list = linkedList.subList(i, Math.min(i + 150, n));
            linkedList2.add(this.gson.toJson(list));
            linkedList2.add("true");
            slaveBrowser.createCommand(this.gson.toJson(new JsonCommand(JsonCommand.CommandType.LOADTEST, linkedList2)));
        }
        LinkedList<String> linkedList3 = new LinkedList<String>();
        linkedList3.add("false");
        linkedList3.add("true");
        slaveBrowser.createCommand(this.gson.toJson(new JsonCommand(JsonCommand.CommandType.RUNALLTESTS, linkedList3)));
    }
}

