/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.Command;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.ForwardingMapper;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.LoadedFiles;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.URLTranslator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BrowserQueryResponseServlet
extends HttpServlet {
    private static final long serialVersionUID = 995720234973219411L;
    private static final String NOOP = "noop";
    private final Gson gson = new Gson();
    private final CapturedBrowsers browsers;
    private final URLTranslator urlTranslator;
    private final ForwardingMapper forwardingMapper;

    public BrowserQueryResponseServlet(CapturedBrowsers capturedBrowsers, URLTranslator uRLTranslator, ForwardingMapper forwardingMapper) {
        this.browsers = capturedBrowsers;
        this.urlTranslator = uRLTranslator;
        this.forwardingMapper = forwardingMapper;
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.service(httpServletRequest.getPathInfo().substring(1), httpServletRequest.getParameter("start"), httpServletRequest.getParameter("response"), httpServletRequest.getParameter("done"), httpServletResponse.getWriter());
    }

    public void service(String string, String string2, String string3, String string4, PrintWriter printWriter) {
        SlaveBrowser slaveBrowser = this.browsers.getBrowser(string);
        if (slaveBrowser != null) {
            Object object;
            Object object2;
            slaveBrowser.heartBeat();
            if (string3 != null && slaveBrowser.isCommandRunning()) {
                LoadedFiles loadedFiles;
                object2 = this.gson.fromJson(string3, Response.class);
                if (((Response)object2).getResponse().contains("\"loadedFiles\":") && !(object = (loadedFiles = this.gson.fromJson(((Response)object2).getResponse(), LoadedFiles.class)).getLoadedFiles()).isEmpty()) {
                    LinkedHashSet<FileInfo> linkedHashSet = new LinkedHashSet<FileInfo>();
                    LinkedHashSet<FileSource> linkedHashSet2 = new LinkedHashSet<FileSource>();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        FileResult fileResult = (FileResult)iterator.next();
                        FileSource fileSource = fileResult.getFileSource();
                        if (fileResult.isSuccess()) {
                            String string5 = fileSource.getFileSrc();
                            linkedHashSet.add(new FileInfo(fileSource.getBasePath(), fileSource.getTimestamp(), false, false, null));
                            continue;
                        }
                        linkedHashSet2.add(fileSource);
                    }
                    slaveBrowser.addFiles(linkedHashSet);
                    if (linkedHashSet2.size() > 0) {
                        slaveBrowser.removeFiles(linkedHashSet2);
                    }
                }
                boolean bl = string4 != null;
                slaveBrowser.addResponse(string3, bl);
                if (!bl) {
                    printWriter.print(NOOP);
                    printWriter.flush();
                    return;
                }
            }
            object2 = null;
            if (string2 != null) {
                slaveBrowser.resetFileSet();
                this.urlTranslator.clear();
                this.forwardingMapper.clear();
                Command command = slaveBrowser.getCommandRunning();
                if (command != null && ((JsonCommand)(object = this.gson.fromJson(command.getCommand(), JsonCommand.class))).getCommand().equals(JsonCommand.CommandType.RESET.getCommand())) {
                    object2 = slaveBrowser.getLastDequeuedCommand();
                }
            } else {
                object2 = slaveBrowser.dequeueCommand();
            }
            printWriter.print(object2 != null ? ((Command)object2).getCommand() : NOOP);
        }
        printWriter.flush();
    }
}

