/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.Action;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.RunTestsAction;
import com.google.jstestdriver.ThreadedAction;
import com.google.jstestdriver.ThreadedActionRunner;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedActionsRunner
implements Action {
    private final JsTestDriverClient client;
    private final List<ThreadedAction> actions;
    private final ExecutorService executor;

    public ThreadedActionsRunner(JsTestDriverClient jsTestDriverClient, List<ThreadedAction> list, ExecutorService executorService) {
        this.client = jsTestDriverClient;
        this.actions = list;
        this.executor = executorService;
    }

    @Override
    public void run() {
        Collection<BrowserInfo> collection = this.client.listBrowsers();
        int n = collection.size();
        if (n == 0) {
            System.err.println("No browsers were captured, nothing to run...");
        }
        CountDownLatch countDownLatch = new CountDownLatch(n);
        for (BrowserInfo browserInfo : collection) {
            this.executor.submit(new ThreadedActionRunner(browserInfo.getId().toString(), this.client, countDownLatch, this.actions));
        }
        this.executor.shutdown();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public List<ThreadedAction> getActions() {
        return this.actions;
    }

    public RunTestsAction getRunTestsAction() {
        for (ThreadedAction threadedAction : this.actions) {
            if (!(threadedAction instanceof RunTestsAction)) continue;
            return (RunTestsAction)threadedAction;
        }
        return null;
    }

    public JsTestDriverClient getClient() {
        return this.client;
    }
}

