/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.html;

import com.google.jstestdriver.html.HtmlDocParser;
import com.google.jstestdriver.html.TextNode;
import com.google.jstestdriver.token.BufferedTokenStream;
import com.google.jstestdriver.token.ConcreteToken;
import com.google.jstestdriver.token.Nodes;
import com.google.jstestdriver.token.Token;

public class BlockNodeFactory
implements HtmlDocParser.NodeFactory {
    private static final ConcreteToken BLOCK_START_TOKEN = new ConcreteToken("{".toCharArray());
    private static final ConcreteToken BLOCK_END_TOKEN = new ConcreteToken("}".toCharArray());
    private final HtmlDocParser.NodeFactory[] factories;

    public BlockNodeFactory(HtmlDocParser.NodeFactory[] nodeFactoryArray) {
        this.factories = nodeFactoryArray;
    }

    public void create(BufferedTokenStream bufferedTokenStream, Nodes nodes) {
        if (!BLOCK_START_TOKEN.equals(bufferedTokenStream.read())) {
            bufferedTokenStream.reset();
            return;
        }
        nodes.add(new TextNode(BLOCK_START_TOKEN));
        bufferedTokenStream.mark();
        while (bufferedTokenStream.available()) {
            Token token = bufferedTokenStream.read();
            if (BLOCK_END_TOKEN.equals(token)) {
                bufferedTokenStream.mark();
                nodes.add(new TextNode(BLOCK_END_TOKEN));
                return;
            }
            if (BLOCK_START_TOKEN.equals(token)) {
                bufferedTokenStream.reset();
                this.create(bufferedTokenStream, nodes);
                return;
            }
            bufferedTokenStream.reset();
            for (HtmlDocParser.NodeFactory nodeFactory : this.factories) {
                nodeFactory.create(bufferedTokenStream, nodes);
            }
        }
    }
}

