/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Module;
import com.google.jstestdriver.Plugin;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader {
    public List<Module> load(List<Plugin> list) {
        LinkedList<Module> linkedList = new LinkedList<Module>();
        for (Plugin plugin : list) {
            try {
                URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{new URL("jar:file:" + plugin.getPathToJar() + "!/")}, this.getClass().getClassLoader());
                Class<Module> clazz = Class.forName(plugin.getModuleName(), true, uRLClassLoader);
                linkedList.add(this.getModuleInstance(plugin, clazz));
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
        }
        return linkedList;
    }

    private Module getModuleInstance(Plugin plugin, Class<Module> clazz) {
        try {
            Constructor<Module> constructor = clazz.getConstructor(List.class);
            return constructor.newInstance(plugin.getArgs());
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }
}

