/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.ResponseStreamFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatingResponseStreamFactory
implements ResponseStreamFactory {
    private final Set<ResponseStreamFactory> factories;

    @Inject
    public AggregatingResponseStreamFactory(Set<ResponseStreamFactory> set) {
        this.factories = set;
    }

    @Override
    public ResponseStream getDryRunActionResponseStream() {
        LinkedList<ResponseStream> linkedList = Lists.newLinkedList();
        for (ResponseStreamFactory responseStreamFactory : this.factories) {
            linkedList.add(responseStreamFactory.getDryRunActionResponseStream());
        }
        return new AggregatingResponseStream(linkedList);
    }

    @Override
    public ResponseStream getEvalActionResponseStream() {
        LinkedList<ResponseStream> linkedList = Lists.newLinkedList();
        for (ResponseStreamFactory responseStreamFactory : this.factories) {
            linkedList.add(responseStreamFactory.getEvalActionResponseStream());
        }
        return new AggregatingResponseStream(linkedList);
    }

    @Override
    public ResponseStream getResetActionResponseStream() {
        LinkedList<ResponseStream> linkedList = Lists.newLinkedList();
        for (ResponseStreamFactory responseStreamFactory : this.factories) {
            linkedList.add(responseStreamFactory.getResetActionResponseStream());
        }
        return new AggregatingResponseStream(linkedList);
    }

    @Override
    public ResponseStream getRunTestsActionResponseStream(String string) {
        LinkedList<ResponseStream> linkedList = Lists.newLinkedList();
        for (ResponseStreamFactory responseStreamFactory : this.factories) {
            linkedList.add(responseStreamFactory.getRunTestsActionResponseStream(string));
        }
        return new AggregatingResponseStream(linkedList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AggregatingResponseStream
    implements ResponseStream {
        private final List<ResponseStream> streams;

        public AggregatingResponseStream(List<ResponseStream> list) {
            this.streams = list;
        }

        @Override
        public void finish() {
            for (ResponseStream responseStream : this.streams) {
                responseStream.finish();
            }
        }

        @Override
        public void stream(Response response) {
            for (ResponseStream responseStream : this.streams) {
                responseStream.stream(response);
            }
        }
    }
}

