/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 56 "parse.y"

#include "sqliteInt.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/

struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int notValue;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 47 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 248
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 59
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  int yy46;
  struct LikeOp yy72;
  Expr* yy172;
  ExprList* yy174;
  Select* yy219;
  struct LimitVal yy234;
  TriggerStep* yy243;
  struct TrigEvent yy370;
  SrcList* yy373;
  Expr * yy386;
  struct {int value; int mask;} yy405;
  Token yy410;
  IdList* yy432;
  int yy495;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 588
#define YYNRULE 312
#define YYERRORSYMBOL 138
#define YYERRSYMDT yy495
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   299,  901,  124,  587,  416,  174,    2,  425,   61,   61,
 /*    10 */    61,   61,  297,   63,   63,   63,   63,   64,   64,   65,
 /*    20 */    65,   65,   66,  212,  454,  214,  432,  438,   68,   63,
 /*    30 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  212,
 /*    40 */   398,  395,  403,  458,   60,   59,  304,  442,  443,  439,
 /*    50 */   439,   62,   62,   61,   61,   61,   61,  265,   63,   63,
 /*    60 */    63,   63,   64,   64,   65,   65,   65,   66,  212,  299,
 /*    70 */   500,  501,  425,  496,  210,   82,   67,  427,   69,  156,
 /*    80 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*    90 */   212,   67,  469,   69,  156,  432,  438,  573,  266,   58,
 /*   100 */    64,   64,   65,   65,   65,   66,  212,  404,  405,  429,
 /*   110 */   429,  429,  299,   60,   59,  304,  442,  443,  439,  439,
 /*   120 */    62,   62,   61,   61,   61,   61,  324,   63,   63,   63,
 /*   130 */    63,   64,   64,   65,   65,   65,   66,  212,  432,  438,
 /*   140 */    94,   65,   65,   65,   66,  212,  403,  212,  421,   34,
 /*   150 */    56,  305,  449,  450,  417,  481,   60,   59,  304,  442,
 /*   160 */   443,  439,  439,   62,   62,   61,   61,   61,   61,  495,
 /*   170 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   180 */   212,  299,  259,  524,  203,  571,  113,  415,  522,  458,
 /*   190 */   338,  324,  414,   20,  241,  347,  297,  403,  471,  531,
 /*   200 */   292,  454,  214,  570,  569,  472,  530,  432,  438,  151,
 /*   210 */   152,  404,  405,  421,   41,  213,  153,  533,  422,  496,
 /*   220 */   263,  568,  261,  427,  299,   60,   59,  304,  442,  443,
 /*   230 */   439,  439,   62,   62,   61,   61,   61,   61,  324,   63,
 /*   240 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  212,
 /*   250 */   432,  438,  454,  340,  217,  429,  429,  429,  219,  550,
 /*   260 */   421,   41,  404,  405,  490,  567,  213,  299,   60,   59,
 /*   270 */   304,  442,  443,  439,  439,   62,   62,   61,   61,   61,
 /*   280 */    61,  652,   63,   63,   63,   63,   64,   64,   65,   65,
 /*   290 */    65,   66,  212,  432,  438,  103,  652,  549,  524,  519,
 /*   300 */   652,  216,  652,   67,  231,   69,  156,  534,   20,   66,
 /*   310 */   212,   60,   59,  304,  442,  443,  439,  439,   62,   62,
 /*   320 */    61,   61,   61,   61,  265,   63,   63,   63,   63,   64,
 /*   330 */    64,   65,   65,   65,   66,  212,  654,  324,  288,   77,
 /*   340 */   299,  456,  523,  170,  491,  155,  232,  380,  271,  270,
 /*   350 */   327,  654,  445,  445,  485,  654,  485,  654,  210,  421,
 /*   360 */    27,  456,  330,  170,  652,  391,  432,  438,  497,  425,
 /*   370 */   652,  652,  652,  652,  652,  652,  652,  252,  654,  422,
 /*   380 */   581,  291,   80,  652,   60,   59,  304,  442,  443,  439,
 /*   390 */   439,   62,   62,   61,   61,   61,   61,  210,   63,   63,
 /*   400 */    63,   63,   64,   64,   65,   65,   65,   66,  212,  299,
 /*   410 */   379,  585,  892,  494,  892,  306,  393,  368,  324,  654,
 /*   420 */    21,  324,  307,  324,  425,  654,  654,  654,  654,  654,
 /*   430 */   654,  654,  571,  654,  425,  432,  438,  532,  654,  654,
 /*   440 */   421,   49,  485,  421,   35,  421,   49,  329,  449,  450,
 /*   450 */   570,  582,  348,   60,   59,  304,  442,  443,  439,  439,
 /*   460 */    62,   62,   61,   61,   61,   61,  655,   63,   63,   63,
 /*   470 */    63,   64,   64,   65,   65,   65,   66,  212,  299,  420,
 /*   480 */   198,  655,  509,  419,  324,  655,  315,  655,  653,  425,
 /*   490 */   223,  316,  653,  525,  653,  238,  166,  118,  245,  350,
 /*   500 */   250,  351,  178,  314,  432,  438,  421,   34,  655,  254,
 /*   510 */   239,  213,  389,  213,  422,  653,  588,  398,  395,  406,
 /*   520 */   407,  408,   60,   59,  304,  442,  443,  439,  439,   62,
 /*   530 */    62,   61,   61,   61,   61,  335,   63,   63,   63,   63,
 /*   540 */    64,   64,   65,   65,   65,   66,  212,  299,  342,  655,
 /*   550 */   307,  257,  463,  547,  501,  655,  655,  655,  655,  655,
 /*   560 */   655,  655,  653,  655,  464,  653,  653,  653,  655,  655,
 /*   570 */   653,  161,  498,  432,  438,  653,  653,  465,    1,  502,
 /*   580 */   544,  418,  403,  585,  891,  176,  891,  343,  174,  503,
 /*   590 */   425,   60,   59,  304,  442,  443,  439,  439,   62,   62,
 /*   600 */    61,   61,   61,   61,  240,   63,   63,   63,   63,   64,
 /*   610 */    64,   65,   65,   65,   66,  212,  299,  381,  223,  422,
 /*   620 */     9,   93,  377,  582,  403,  118,  245,  350,  250,  351,
 /*   630 */   178,  177,  162,  325,  403,  183,  345,  254,  352,  355,
 /*   640 */   356,  227,  432,  438,  446,  320,  399,  404,  405,  357,
 /*   650 */   459,  209,  540,  367,  540,  425,  546,  302,  202,  299,
 /*   660 */    60,   59,  304,  442,  443,  439,  439,   62,   62,   61,
 /*   670 */    61,   61,   61,  402,   63,   63,   63,   63,   64,   64,
 /*   680 */    65,   65,   65,   66,  212,  432,  438,  225,  524,  404,
 /*   690 */   405,  489,  422,  397,   18,  824,    2,  578,   20,  404,
 /*   700 */   405,  194,  299,   60,   59,  304,  442,  443,  439,  439,
 /*   710 */    62,   62,   61,   61,   61,   61,  386,   63,   63,   63,
 /*   720 */    63,   64,   64,   65,   65,   65,   66,  212,  432,  438,
 /*   730 */   327,  370,  445,  445,  481,  422,  327,  373,  445,  445,
 /*   740 */   275,  519,  519,    8,  394,  299,   60,   70,  304,  442,
 /*   750 */   443,  439,  439,   62,   62,   61,   61,   61,   61,  378,
 /*   760 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   770 */   212,  432,  438,  243,  211,  167,  310,  224,  278,  196,
 /*   780 */   276,   55,  374,  519,  180,  181,  182,  519,  299,  119,
 /*   790 */    59,  304,  442,  443,  439,  439,   62,   62,   61,   61,
 /*   800 */    61,   61,  646,   63,   63,   63,   63,   64,   64,   65,
 /*   810 */    65,   65,   66,  212,  432,  438,  403,  646,  311,  253,
 /*   820 */   253,  646,  312,  646,  327,    5,  445,  445,  481,  542,
 /*   830 */   154,  519,  474,  541,  304,  442,  443,  439,  439,   62,
 /*   840 */    62,   61,   61,   61,   61,  369,   63,   63,   63,   63,
 /*   850 */    64,   64,   65,   65,   65,   66,  212,   72,  331,  277,
 /*   860 */     4,  253,  377,  428,  303,  253,  313,  487,  622,  173,
 /*   870 */   162,  455,  328,   72,  331,  265,    4,  265,   84,  158,
 /*   880 */   303,  404,  405,  265,   67,  646,   69,  156,  328,  333,
 /*   890 */   360,  646,  646,  646,  646,  646,  646,  646,  183,  458,
 /*   900 */   185,  352,  355,  356,  646,  333,  388,  477,  188,  253,
 /*   910 */   433,  434,  357,  422,  463,  458,  557,  179,  559,   75,
 /*   920 */    74,  336,  403,  147,  560,  210,  464,  226,   73,  322,
 /*   930 */   323,  436,  437,  427,  422,   75,   74,  488,  387,  465,
 /*   940 */   475,  334,  422,  512,   73,  322,  323,   72,  331,  427,
 /*   950 */     4,  210,  467,  324,  303,  318,  123,   19,  480,  144,
 /*   960 */   435,  157,  328,  513,  484,  429,  429,  429,  430,  431,
 /*   970 */    11,  346,  301,  452,  452,  421,   34,  254,  324,  333,
 /*   980 */   251,  429,  429,  429,  430,  431,   11,  404,  405,  458,
 /*   990 */   265,  164,  293,  421,    3,  422,  228,  229,  230,  104,
 /*  1000 */   421,   28,  324,  403,  294,  324,  265,  265,  265,   75,
 /*  1010 */    74,  656,  207,  478,  283,  309,  179,  338,   73,  322,
 /*  1020 */   323,  284,  337,  427,  421,   23,  656,  421,   32,  324,
 /*  1030 */   656,  561,  656,  205,  420,  549,  326,  526,  419,  204,
 /*  1040 */   324,  128,  206,  324,  476,  511,  510,  279,  385,  281,
 /*  1050 */   514,  421,   53,  656,  515,  429,  429,  429,  430,  431,
 /*  1060 */    11,  649,  421,   52,  258,  421,   98,  324,  404,  405,
 /*  1070 */   183,  301,  260,  352,  355,  356,  649,   76,  650,   78,
 /*  1080 */   649,  246,  649,  262,  357,  384,  280,  270,  264,  421,
 /*  1090 */    96,  300,  247,  650,  656,  324,  210,  650,  191,  650,
 /*  1100 */   656,  656,  656,  656,  656,  656,  656,  653,  656,  324,
 /*  1110 */   364,  160,  440,  656,  656,  324,  295,  421,  101,  324,
 /*  1120 */   390,  583,  653,  324,  269,  324,  653,  447,  653,   22,
 /*  1130 */   372,  421,  102,  412,  375,  324,  476,  421,  112,  376,
 /*  1140 */   272,  421,  114,  324,  649,  421,   16,  421,   99,  653,
 /*  1150 */   649,  649,  649,  649,  649,  649,  649,  421,   33,  324,
 /*  1160 */   584,  650,  324,  649,  273,  421,   97,  650,  650,  650,
 /*  1170 */   650,  650,  650,  650,  483,  274,  175,  506,  507,  556,
 /*  1180 */   650,  421,   24,  324,  421,   54,  566,  516,  324,  128,
 /*  1190 */   653,  324,  256,  359,  128,  128,  653,  653,  653,  653,
 /*  1200 */   653,  653,  653,  324,  653,  421,  115,  146,  324,  653,
 /*  1210 */   421,  116,  282,  421,  117,  324,  545,  324,  128,  285,
 /*  1220 */   553,  324,  175,  324,  233,  421,   25,  554,  324,   91,
 /*  1230 */   421,   36,  324,  286,  324,  577,  426,  421,   37,  421,
 /*  1240 */    26,  324,  451,  421,   38,  421,   39,  324,  332,  324,
 /*  1250 */   421,   40,  324,  453,  421,   42,  421,   43,  564,  292,
 /*  1260 */    91,  324,  470,  421,   44,  324,  580,  324,  290,  421,
 /*  1270 */    29,  421,   30,  324,  421,   45,  324,  518,  298,  324,
 /*  1280 */   473,  248,  517,  421,   46,  324,  354,  421,   47,  421,
 /*  1290 */    48,  520,  552,  563,  165,  421,   31,  401,  421,   10,
 /*  1300 */     7,  421,   50,  409,  410,  411,  321,  421,   51,   84,
 /*  1310 */   423,  341,  237,   83,  339,   57,  234,   79,  235,  215,
 /*  1320 */   236,  172,   85,  424,  349,  344,  468,  125,  505,  308,
 /*  1330 */   295,  242,  499,  482,  244,  504,  486,  249,  508,  296,
 /*  1340 */   105,  221,  521,  149,  361,  150,  365,  527,  528,  529,
 /*  1350 */   186,   88,  121,  535,  187,  132,  363,  189,  142,  220,
 /*  1360 */   222,  383,  141,  190,  537,  192,  548,  371,  195,  267,
 /*  1370 */   382,  538,  133,  555,  562,  317,  134,  135,  136,   92,
 /*  1380 */   574,  138,   95,  575,  576,  579,  111,  100,  400,  319,
 /*  1390 */   122,   17,  413,  623,  624,  168,  169,  441,  444,   71,
 /*  1400 */   460,  448,  457,  143,  159,  171,  461,    6,  462,  479,
 /*  1410 */   466,   13,  126,   81,   12,  127,  163,  492,  493,  218,
 /*  1420 */    86,  353,  106,  358,  255,  107,  120,   87,  108,  184,
 /*  1430 */   247,  362,  145,  536,  175,  129,  366,  193,  109,  268,
 /*  1440 */   289,  551,  131,   14,  130,  197,   89,  539,  199,  201,
 /*  1450 */   543,  200,  139,  558,  137,  565,  110,   15,  287,  572,
 /*  1460 */   140,  208,  148,  396,  392,  586,  902,  902,  902,  902,
 /*  1470 */    90,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  139,  140,  141,  168,   21,  144,   23,   69,   70,
 /*    10 */    71,   72,  176,   74,   75,   76,   77,   78,   79,   80,
 /*    20 */    81,   82,   83,   84,   78,   79,   42,   43,   73,   74,
 /*    30 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    40 */     1,    2,   23,   58,   60,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,  147,   74,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */   185,  186,   88,   88,  110,   22,  217,   92,  219,  220,
 /*    80 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    90 */    84,  217,  218,  219,  220,   42,   43,  238,  188,   46,
 /*   100 */    78,   79,   80,   81,   82,   83,   84,   88,   89,  124,
 /*   110 */   125,  126,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,  147,   74,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    44,   80,   81,   82,   83,   84,   23,   84,  169,  170,
 /*   150 */    19,  164,  165,  166,   23,  161,   60,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  169,
 /*   170 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   16,   14,  147,  155,  147,   21,  167,  168,   58,
 /*   190 */   211,  147,  156,  157,  200,  216,  176,   23,   27,  176,
 /*   200 */   177,   78,   79,  165,  166,   34,  183,   42,   43,   78,
 /*   210 */    79,   88,   89,  169,  170,  228,  180,  181,  189,   88,
 /*   220 */    52,   98,   54,   92,   16,   60,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,  147,   74,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    42,   43,   78,  209,  210,  124,  125,  126,  175,   11,
 /*   260 */   169,  170,   88,   89,   20,  227,  228,   16,   60,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,    1,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */    82,   83,   84,   42,   43,  175,   16,   49,  147,  147,
 /*   300 */    20,  210,   22,  217,  153,  219,  220,  156,  157,   83,
 /*   310 */    84,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   320 */    69,   70,   71,   72,  147,   74,   75,   76,   77,   78,
 /*   330 */    79,   80,   81,   82,   83,   84,    1,  147,  158,  131,
 /*   340 */    16,  161,  162,  163,   20,  155,  190,   99,  100,  101,
 /*   350 */   106,   16,  108,  109,  147,   20,  147,   22,  110,  169,
 /*   360 */   170,  161,  162,  163,   84,  188,   42,   43,  169,   23,
 /*   370 */    90,   91,   92,   93,   94,   95,   96,  225,   43,  189,
 /*   380 */   244,  245,  131,  103,   60,   61,   62,   63,   64,   65,
 /*   390 */    66,   67,   68,   69,   70,   71,   72,  110,   74,   75,
 /*   400 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*   410 */   123,   19,   20,   20,   22,  208,  239,  208,  147,   84,
 /*   420 */    19,  147,   16,  147,   23,   90,   91,   92,   93,   94,
 /*   430 */    95,   96,  147,   98,   88,   42,   43,  181,  103,  104,
 /*   440 */   169,  170,  147,  169,  170,  169,  170,  164,  165,  166,
 /*   450 */   165,   59,   80,   60,   61,   62,   63,   64,   65,   66,
 /*   460 */    67,   68,   69,   70,   71,   72,    1,   74,   75,   76,
 /*   470 */    77,   78,   79,   80,   81,   82,   83,   84,   16,  107,
 /*   480 */   155,   16,   20,  111,  147,   20,  215,   22,   16,   88,
 /*   490 */    84,  215,   20,  181,   22,  221,   90,   91,   92,   93,
 /*   500 */    94,   95,   96,  208,   42,   43,  169,  170,   43,  103,
 /*   510 */   147,  228,  227,  228,  189,   43,    0,    1,    2,    7,
 /*   520 */     8,    9,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   530 */    68,   69,   70,   71,   72,  186,   74,   75,   76,   77,
 /*   540 */    78,   79,   80,   81,   82,   83,   84,   16,  211,   84,
 /*   550 */    16,   20,   12,  185,  186,   90,   91,   92,   93,   94,
 /*   560 */    95,   96,   90,   98,   24,   93,   94,   95,  103,  104,
 /*   570 */    98,  147,  160,   42,   43,  103,  104,   37,   19,   39,
 /*   580 */    18,  169,   23,   19,   20,  155,   22,  147,   21,   49,
 /*   590 */    23,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   600 */    69,   70,   71,   72,  147,   74,   75,   76,   77,   78,
 /*   610 */    79,   80,   81,   82,   83,   84,   16,   55,   84,  189,
 /*   620 */    19,   21,  147,   59,   23,   91,   92,   93,   94,   95,
 /*   630 */    96,  201,  202,  147,   23,   90,  206,  103,   93,   94,
 /*   640 */    95,  145,   42,   43,   20,  142,  143,   88,   89,  104,
 /*   650 */    20,  148,   99,  100,  101,   88,   94,  150,  155,   16,
 /*   660 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   670 */    70,   71,   72,  147,   74,   75,   76,   77,   78,   79,
 /*   680 */    80,   81,   82,   83,   84,   42,   43,  212,  147,   88,
 /*   690 */    89,   80,  189,  141,   19,  133,  144,  156,  157,   88,
 /*   700 */    89,  155,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   710 */    67,   68,   69,   70,   71,   72,  213,   74,   75,   76,
 /*   720 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   730 */   106,  224,  108,  109,  161,  189,  106,  230,  108,  109,
 /*   740 */    14,  147,  147,   68,  241,   16,   60,   61,   62,   63,
 /*   750 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  213,
 /*   760 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   770 */    84,   42,   43,  200,  192,   19,  182,  182,   52,   22,
 /*   780 */    54,  199,  236,  147,   99,  100,  101,  147,   16,  147,
 /*   790 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   800 */    71,   72,    1,   74,   75,   76,   77,   78,   79,   80,
 /*   810 */    81,   82,   83,   84,   42,   43,   23,   16,  182,  225,
 /*   820 */   225,   20,  182,   22,  106,  191,  108,  109,  161,   25,
 /*   830 */    22,  147,   22,   29,   62,   63,   64,   65,   66,   67,
 /*   840 */    68,   69,   70,   71,   72,   41,   74,   75,   76,   77,
 /*   850 */    78,   79,   80,   81,   82,   83,   84,   16,   17,  133,
 /*   860 */    19,  225,  147,  147,   23,  225,  182,  200,  112,  201,
 /*   870 */   202,  161,   31,   16,   17,  147,   19,  147,  121,  155,
 /*   880 */    23,   88,   89,  147,  217,   84,  219,  220,   31,   48,
 /*   890 */    16,   90,   91,   92,   93,   94,   95,   96,   90,   58,
 /*   900 */   155,   93,   94,   95,  103,   48,   91,  114,  155,  225,
 /*   910 */    42,   43,  104,  189,   12,   58,  188,   43,  188,   78,
 /*   920 */    79,  147,   23,  113,  188,  110,   24,  212,   87,   88,
 /*   930 */    89,   63,   64,   92,  189,   78,   79,   80,  123,   37,
 /*   940 */   203,   39,  189,   30,   87,   88,   89,   16,   17,   92,
 /*   950 */    19,  110,  147,  147,   23,  242,  243,   19,  147,   21,
 /*   960 */    92,  155,   31,   50,  147,  124,  125,  126,  127,  128,
 /*   970 */   129,  147,   98,  124,  125,  169,  170,  103,  147,   48,
 /*   980 */   147,  124,  125,  126,  127,  128,  129,   88,   89,   58,
 /*   990 */   147,    5,  147,  169,  170,  189,   10,   11,   12,   13,
 /*  1000 */   169,  170,  147,   23,  178,  147,  147,  147,  147,   78,
 /*  1010 */    79,    1,   26,  114,   28,  102,   43,  211,   87,   88,
 /*  1020 */    89,   35,  216,   92,  169,  170,   16,  169,  170,  147,
 /*  1030 */    20,  188,   22,   47,  107,   49,   16,  147,  111,   53,
 /*  1040 */   147,   22,   56,  147,   22,   91,   92,  188,  188,  188,
 /*  1050 */   178,  169,  170,   43,  178,  124,  125,  126,  127,  128,
 /*  1060 */   129,    1,  169,  170,  147,  169,  170,  147,   88,   89,
 /*  1070 */    90,   98,  147,   93,   94,   95,   16,  130,    1,  132,
 /*  1080 */    20,   92,   22,  147,  104,   99,  100,  101,  147,  169,
 /*  1090 */   170,  105,  103,   16,   84,  147,  110,   20,  232,   22,
 /*  1100 */    90,   91,   92,   93,   94,   95,   96,    1,   98,  147,
 /*  1110 */   233,   89,   92,  103,  104,  147,   97,  169,  170,  147,
 /*  1120 */   134,   20,   16,  147,  147,  147,   20,   20,   22,   22,
 /*  1130 */   147,  169,  170,  149,  147,  147,  114,  169,  170,  147,
 /*  1140 */   147,  169,  170,  147,   84,  169,  170,  169,  170,   43,
 /*  1150 */    90,   91,   92,   93,   94,   95,   96,  169,  170,  147,
 /*  1160 */    59,   84,  147,  103,  147,  169,  170,   90,   91,   92,
 /*  1170 */    93,   94,   95,   96,   20,  147,   22,    7,    8,  147,
 /*  1180 */   103,  169,  170,  147,  169,  170,  147,   20,  147,   22,
 /*  1190 */    84,  147,   20,   20,   22,   22,   90,   91,   92,   93,
 /*  1200 */    94,   95,   96,  147,   98,  169,  170,  191,  147,  103,
 /*  1210 */   169,  170,  147,  169,  170,  147,   20,  147,   22,  147,
 /*  1220 */    20,  147,   22,  147,  193,  169,  170,   20,  147,   22,
 /*  1230 */   169,  170,  147,  147,  147,  147,  161,  169,  170,  169,
 /*  1240 */   170,  147,  229,  169,  170,  169,  170,  147,  223,  147,
 /*  1250 */   169,  170,  147,  229,  169,  170,  169,  170,   20,  177,
 /*  1260 */    22,  147,  172,  169,  170,  147,   20,  147,   22,  169,
 /*  1270 */   170,  169,  170,  147,  169,  170,  147,  161,  161,  147,
 /*  1280 */   172,  172,  172,  169,  170,  147,  173,  169,  170,  169,
 /*  1290 */   170,  172,  194,  194,    6,  169,  170,  146,  169,  170,
 /*  1300 */    22,  169,  170,  146,  146,  146,  154,  169,  170,  121,
 /*  1310 */   189,  118,  197,  119,  116,  120,  194,  130,  195,  222,
 /*  1320 */   196,  112,   98,  198,   98,  115,  152,  152,  179,   40,
 /*  1330 */    97,  204,  171,  205,  204,  171,  205,  171,  173,  171,
 /*  1340 */    19,   84,  179,  174,   15,  174,   38,  171,  171,  171,
 /*  1350 */   151,  130,   60,  152,  151,   19,  152,  151,  214,  226,
 /*  1360 */   226,   15,  214,  152,  152,  151,  184,  152,  184,  234,
 /*  1370 */   152,  235,  187,  194,  194,  152,  187,  187,  187,  237,
 /*  1380 */    33,  184,  237,  152,  152,  137,  240,  159,    1,  246,
 /*  1390 */   243,  231,   20,  112,  112,  112,  112,   92,  107,   19,
 /*  1400 */    11,   20,   20,   19,   19,   22,   20,  117,   20,  114,
 /*  1410 */    20,  117,   19,   22,   22,   20,  112,   20,   20,   44,
 /*  1420 */    19,   44,   19,   44,   20,   19,   32,   19,   19,   96,
 /*  1430 */   103,   16,   21,   17,   22,   98,   36,   98,   19,  133,
 /*  1440 */     5,    1,  102,   19,   45,  122,   68,   51,  113,  115,
 /*  1450 */    45,   14,  102,   17,  113,  123,   14,   19,  136,   20,
 /*  1460 */   122,  135,   19,    3,   57,    4,  247,  247,  247,  247,
 /*  1470 */    68,
};
#define YY_SHIFT_USE_DFLT (-62)
#define YY_SHIFT_MAX 396
static const short yy_shift_ofst[] = {
 /*     0 */    39,  841,  986,  -16,  841,  931,  931,  980,  123,  -36,
 /*    10 */    96,  931,  931,  931,  931,  931,  -45,  248,  174,   19,
 /*    20 */   346,  -54,  -54,   53,  165,  208,  251,  324,  393,  462,
 /*    30 */   531,  600,  643,  686,  643,  643,  643,  643,  643,  643,
 /*    40 */   643,  643,  643,  643,  643,  643,  643,  643,  643,  643,
 /*    50 */   643,  643,  729,  772,  772,  857,  931,  931,  931,  931,
 /*    60 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    70 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    80 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    90 */   931,  931,  931,  931,  931,  931,  -61,  -61,    6,    6,
 /*   100 */   406,   22,   61,  874,  562,   19,   19,   19,   19,   19,
 /*   110 */    19,   19,  226,  346,   63,  -62,  -62,  -62,  131,  534,
 /*   120 */   540,  540,  392,  564,  516,  567,   19,  567,   19,   19,
 /*   130 */    19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
 /*   140 */    19,  815,  287,  -36,  -36,  -36,  -62,  -62,  -62, 1106,
 /*   150 */   472,  -15,  -15,  808,  545,  244,  559,  624,  630,  902,
 /*   160 */   793,  899,  601,  611,  512,   19,   19,  372,   19,   19,
 /*   170 */   401,   19,   19, 1022,   19,   19,  718, 1022,   19,   19,
 /*   180 */   913,  913,  913,   19,   19,  718,   19,   19,  718,   19,
 /*   190 */   804,  553,   19,   19,  718,   19,   19,   19,  718,   19,
 /*   200 */    19,   19,  718,  718,   19,   19,   19,   19,   19,  938,
 /*   210 */   927,  810,  346,  849,  849,  947,  171,  171,  171,  973,
 /*   220 */   171,  346,  171,  346, 1019,  757,  757, 1288, 1288, 1288,
 /*   230 */  1288, 1278,  -36, 1188, 1193, 1194, 1198, 1195, 1187, 1209,
 /*   240 */  1209, 1224, 1210, 1224, 1210, 1226, 1226, 1289, 1226, 1233,
 /*   250 */  1226, 1321, 1257, 1257, 1289, 1226, 1226, 1226, 1321, 1329,
 /*   260 */  1209, 1329, 1209, 1329, 1209, 1209, 1308, 1221, 1329, 1209,
 /*   270 */  1292, 1292, 1336, 1188, 1209, 1346, 1346, 1346, 1346, 1188,
 /*   280 */  1292, 1336, 1209, 1347, 1347, 1209, 1209, 1248,  -62,  -62,
 /*   290 */   -62,  -62,  335,  465, 1010,  280,  801, 1060, 1077,  868,
 /*   300 */   726,  685,  168,  756, 1020, 1107, 1154,  989, 1170,  954,
 /*   310 */  1167, 1172, 1173, 1196, 1200, 1207, 1238,  675, 1246, 1101,
 /*   320 */  1387, 1372, 1281, 1282, 1283, 1284, 1305, 1291, 1380, 1381,
 /*   330 */  1382, 1384, 1389, 1385, 1386, 1383, 1388, 1390, 1391, 1290,
 /*   340 */  1392, 1294, 1391, 1295, 1393, 1395, 1304, 1397, 1398, 1394,
 /*   350 */  1375, 1401, 1377, 1403, 1404, 1406, 1408, 1379, 1409, 1333,
 /*   360 */  1327, 1415, 1416, 1411, 1337, 1400, 1396, 1399, 1412, 1405,
 /*   370 */  1306, 1339, 1419, 1435, 1440, 1340, 1378, 1402, 1323, 1424,
 /*   380 */  1335, 1437, 1334, 1436, 1341, 1350, 1338, 1438, 1332, 1439,
 /*   390 */  1442, 1407, 1326, 1322, 1443, 1460, 1461,
};
#define YY_REDUCE_USE_DFLT (-165)
#define YY_REDUCE_MAX 291
static const short yy_reduce_ofst[] = {
 /*     0 */  -138,  806,  503,  667,  190,  -21,   44,   36,   38,  430,
 /*    10 */  -141,  274,   91,  337,  271,  276, -126,  546,  285,  151,
 /*    20 */   180,  -13,  283,   86,   86,   86,   86,   86,   86,   86,
 /*    30 */    86,   86,   86,   86,   86,   86,   86,   86,   86,   86,
 /*    40 */    86,   86,   86,   86,   86,   86,   86,   86,   86,   86,
 /*    50 */    86,   86,   86,   86,   86,  824,  831,  855,  858,  882,
 /*    60 */   893,  896,  920,  948,  962,  968,  972,  976,  978,  988,
 /*    70 */   996, 1012, 1015, 1036, 1041, 1044, 1056, 1061, 1068, 1070,
 /*    80 */  1074, 1076, 1081, 1085, 1087, 1094, 1100, 1102, 1105, 1114,
 /*    90 */  1118, 1120, 1126, 1129, 1132, 1138,   86,   86,   86,   86,
 /*   100 */    20,   86,   86,   23,  507,  594,  595,  636,  640,  684,
 /*   110 */   177,  541,   86,  200,   86,   86,   86,   86,  412, -164,
 /*   120 */  -115,  368,  136,  136,  552,   -6,  207,  573,  152,  -90,
 /*   130 */   209,  475,  295,  728,  730,  736,  843,  859,  860,  715,
 /*   140 */   861,   29,  325,  724,  745,  753,  582,  668,  713,   83,
 /*   150 */   120,    0,  199,  256,  312,  156,  363,  156,  156,  349,
 /*   160 */   424,  440,  457,  486,  496,  526,  642,  634,  486,  716,
 /*   170 */   710,  774,  805,  737,  811,  817,  156,  737,  833,  845,
 /*   180 */   826,  872,  876,  890,  917,  156,  925,  936,  156,  941,
 /*   190 */   866,  877,  977,  983,  156,  987,  992,  993,  156, 1017,
 /*   200 */  1028, 1032,  156,  156, 1039, 1065, 1072, 1086, 1088,  984,
 /*   210 */  1016, 1031, 1075, 1013, 1024, 1025, 1090, 1108, 1109, 1082,
 /*   220 */  1110, 1116, 1119, 1117, 1113, 1098, 1099, 1151, 1157, 1158,
 /*   230 */  1159, 1152, 1121, 1122, 1123, 1124, 1115, 1125, 1097, 1174,
 /*   240 */  1175, 1127, 1128, 1130, 1131, 1161, 1164, 1149, 1166, 1165,
 /*   250 */  1168, 1169, 1133, 1134, 1163, 1176, 1177, 1178, 1171, 1199,
 /*   260 */  1201, 1203, 1204, 1206, 1211, 1212, 1135, 1136, 1214, 1215,
 /*   270 */  1182, 1184, 1144, 1179, 1218, 1185, 1189, 1190, 1191, 1180,
 /*   280 */  1197, 1148, 1223, 1142, 1145, 1231, 1232, 1146, 1228, 1160,
 /*   290 */  1147, 1143,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   594,  819,  900,  709,  900,  819,  900,  900,  846,  713,
 /*    10 */   875,  817,  900,  900,  900,  900,  791,  900,  846,  900,
 /*    20 */   625,  846,  846,  742,  900,  900,  900,  900,  900,  900,
 /*    30 */   900,  900,  743,  900,  821,  816,  812,  814,  813,  820,
 /*    40 */   744,  733,  740,  747,  725,  859,  749,  750,  756,  757,
 /*    50 */   876,  874,  779,  778,  797,  900,  900,  900,  900,  900,
 /*    60 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*    70 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*    80 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*    90 */   900,  900,  900,  900,  900,  900,  781,  803,  780,  790,
 /*   100 */   618,  782,  783,  678,  613,  900,  900,  900,  900,  900,
 /*   110 */   900,  900,  784,  900,  785,  798,  799,  800,  900,  900,
 /*   120 */   900,  900,  900,  900,  594,  709,  900,  709,  900,  900,
 /*   130 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*   140 */   900,  900,  900,  900,  900,  900,  703,  713,  893,  900,
 /*   150 */   900,  900,  900,  669,  900,  900,  900,  900,  900,  900,
 /*   160 */   900,  900,  900,  900,  601,  599,  900,  701,  900,  900,
 /*   170 */   627,  900,  900,  711,  900,  900,  716,  717,  900,  900,
 /*   180 */   900,  900,  900,  900,  900,  615,  900,  900,  690,  900,
 /*   190 */   852,  900,  900,  900,  866,  900,  900,  900,  864,  900,
 /*   200 */   900,  900,  692,  752,  833,  900,  879,  881,  900,  900,
 /*   210 */   701,  710,  900,  900,  900,  815,  736,  736,  736,  648,
 /*   220 */   736,  900,  736,  900,  651,  746,  746,  598,  598,  598,
 /*   230 */   598,  668,  900,  746,  737,  739,  729,  741,  900,  718,
 /*   240 */   718,  726,  728,  726,  728,  680,  680,  665,  680,  651,
 /*   250 */   680,  825,  830,  830,  665,  680,  680,  680,  825,  610,
 /*   260 */   718,  610,  718,  610,  718,  718,  856,  858,  610,  718,
 /*   270 */   682,  682,  758,  746,  718,  689,  689,  689,  689,  746,
 /*   280 */   682,  758,  718,  878,  878,  718,  718,  886,  635,  861,
 /*   290 */   893,  898,  900,  900,  900,  900,  900,  900,  900,  900,
 /*   300 */   900,  900,  900,  765,  900,  900,  900,  900,  900,  900,
 /*   310 */   900,  900,  900,  900,  900,  900,  900,  839,  900,  900,
 /*   320 */   900,  900,  770,  766,  900,  767,  900,  695,  900,  900,
 /*   330 */   900,  900,  900,  900,  900,  900,  900,  900,  818,  900,
 /*   340 */   730,  900,  738,  900,  900,  900,  900,  900,  900,  900,
 /*   350 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*   360 */   900,  900,  900,  900,  900,  900,  900,  854,  855,  900,
 /*   370 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*   380 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*   390 */   900,  885,  900,  900,  888,  595,  900,  589,  592,  591,
 /*   400 */   593,  597,  600,  622,  623,  624,  602,  603,  604,  605,
 /*   410 */   606,  607,  608,  614,  616,  634,  636,  620,  638,  699,
 /*   420 */   700,  762,  693,  694,  698,  621,  773,  764,  768,  769,
 /*   430 */   771,  772,  786,  787,  789,  795,  802,  805,  788,  793,
 /*   440 */   794,  796,  801,  804,  696,  697,  808,  628,  629,  632,
 /*   450 */   633,  842,  844,  843,  845,  631,  630,  774,  777,  810,
 /*   460 */   811,  867,  868,  869,  870,  871,  806,  719,  809,  792,
 /*   470 */   731,  734,  735,  732,  702,  712,  721,  722,  723,  724,
 /*   480 */   707,  708,  714,  727,  760,  761,  715,  704,  705,  706,
 /*   490 */   807,  763,  775,  776,  639,  640,  770,  641,  642,  643,
 /*   500 */   681,  684,  685,  686,  644,  663,  666,  667,  645,  647,
 /*   510 */   659,  660,  661,  662,  657,  658,  826,  827,  831,  829,
 /*   520 */   828,  664,  637,  626,  619,  670,  673,  674,  675,  676,
 /*   530 */   677,  679,  671,  672,  617,  609,  611,  720,  848,  857,
 /*   540 */   853,  849,  850,  851,  612,  822,  823,  683,  754,  755,
 /*   550 */   847,  860,  862,  759,  863,  865,  890,  687,  688,  691,
 /*   560 */   832,  872,  745,  748,  751,  753,  834,  835,  836,  837,
 /*   570 */   840,  841,  838,  873,  877,  880,  882,  883,  884,  887,
 /*   580 */   889,  894,  895,  896,  899,  897,  596,  590,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "TRIGGER",       "VACUUM",        "VIEW",          "VIRTUAL",     
  "REINDEX",       "RENAME",        "CTIME_KW",      "ANY",         
  "OR",            "AND",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "AUTOINCR",      "ON",            "DELETE",      
  "UPDATE",        "INSERT",        "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "SELECT",        "DISTINCT",    
  "DOT",           "FROM",          "JOIN",          "USING",       
  "ORDER",         "BY",            "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "INTO",          "VALUES",      
  "INTEGER",       "FLOAT",         "BLOB",          "REGISTER",    
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "ALTER",         "TO",          
  "ADD",           "COLUMNKW",      "error",         "input",       
  "cmdlist",       "ecmd",          "cmdx",          "cmd",         
  "explain",       "transtype",     "trans_opt",     "nm",          
  "create_table",  "create_table_args",  "temp",          "ifnotexists", 
  "dbnm",          "columnlist",    "conslist_opt",  "select",      
  "column",        "columnid",      "type",          "carglist",    
  "id",            "ids",           "typetoken",     "typename",    
  "signed",        "plus_num",      "minus_num",     "carg",        
  "ccons",         "term",          "expr",          "onconf",      
  "sortorder",     "autoinc",       "idxlist_opt",   "refargs",     
  "defer_subclause",  "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tcons",         "idxlist",       "defer_subclause_opt",
  "orconf",        "resolvetype",   "raisetype",     "ifexists",    
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "on_opt",        "using_opt",     "seltablist_paren",  "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "nexprlist",   
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "exprlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "uniqueflag",    "idxitem",       "collate",       "nmnum",       
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",  "create_vtab",   "vtabarglist",   "vtabarg",     
  "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "ccons ::= DEFAULT term",
 /*  51 */ "ccons ::= DEFAULT LP expr RP",
 /*  52 */ "ccons ::= DEFAULT PLUS term",
 /*  53 */ "ccons ::= DEFAULT MINUS term",
 /*  54 */ "ccons ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE ids",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 144 */ "sortlist ::= sortitem sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "groupby_opt ::=",
 /* 150 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 151 */ "having_opt ::=",
 /* 152 */ "having_opt ::= HAVING expr",
 /* 153 */ "limit_opt ::=",
 /* 154 */ "limit_opt ::= LIMIT expr",
 /* 155 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 156 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 157 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 158 */ "where_opt ::=",
 /* 159 */ "where_opt ::= WHERE expr",
 /* 160 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 161 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 162 */ "setlist ::= nm EQ expr",
 /* 163 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 164 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 166 */ "insert_cmd ::= INSERT orconf",
 /* 167 */ "insert_cmd ::= REPLACE",
 /* 168 */ "itemlist ::= itemlist COMMA expr",
 /* 169 */ "itemlist ::= expr",
 /* 170 */ "inscollist_opt ::=",
 /* 171 */ "inscollist_opt ::= LP inscollist RP",
 /* 172 */ "inscollist ::= inscollist COMMA nm",
 /* 173 */ "inscollist ::= nm",
 /* 174 */ "expr ::= term",
 /* 175 */ "expr ::= LP expr RP",
 /* 176 */ "term ::= NULL",
 /* 177 */ "expr ::= ID",
 /* 178 */ "expr ::= JOIN_KW",
 /* 179 */ "expr ::= nm DOT nm",
 /* 180 */ "expr ::= nm DOT nm DOT nm",
 /* 181 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 182 */ "term ::= STRING",
 /* 183 */ "expr ::= REGISTER",
 /* 184 */ "expr ::= VARIABLE",
 /* 185 */ "expr ::= expr COLLATE ids",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "likeop ::= MATCH",
 /* 201 */ "likeop ::= NOT MATCH",
 /* 202 */ "escape ::= ESCAPE expr",
 /* 203 */ "escape ::=",
 /* 204 */ "expr ::= expr likeop expr escape",
 /* 205 */ "expr ::= expr ISNULL|NOTNULL",
 /* 206 */ "expr ::= expr IS NULL",
 /* 207 */ "expr ::= expr NOT NULL",
 /* 208 */ "expr ::= expr IS NOT NULL",
 /* 209 */ "expr ::= NOT expr",
 /* 210 */ "expr ::= BITNOT expr",
 /* 211 */ "expr ::= MINUS expr",
 /* 212 */ "expr ::= PLUS expr",
 /* 213 */ "between_op ::= BETWEEN",
 /* 214 */ "between_op ::= NOT BETWEEN",
 /* 215 */ "expr ::= expr between_op expr AND expr",
 /* 216 */ "in_op ::= IN",
 /* 217 */ "in_op ::= NOT IN",
 /* 218 */ "expr ::= expr in_op LP exprlist RP",
 /* 219 */ "expr ::= LP select RP",
 /* 220 */ "expr ::= expr in_op LP select RP",
 /* 221 */ "expr ::= expr in_op nm dbnm",
 /* 222 */ "expr ::= EXISTS LP select RP",
 /* 223 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 224 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 225 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 226 */ "case_else ::= ELSE expr",
 /* 227 */ "case_else ::=",
 /* 228 */ "case_operand ::= expr",
 /* 229 */ "case_operand ::=",
 /* 230 */ "exprlist ::= nexprlist",
 /* 231 */ "exprlist ::=",
 /* 232 */ "nexprlist ::= nexprlist COMMA expr",
 /* 233 */ "nexprlist ::= expr",
 /* 234 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 235 */ "uniqueflag ::= UNIQUE",
 /* 236 */ "uniqueflag ::=",
 /* 237 */ "idxlist_opt ::=",
 /* 238 */ "idxlist_opt ::= LP idxlist RP",
 /* 239 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 240 */ "idxlist ::= idxitem collate sortorder",
 /* 241 */ "idxitem ::= nm",
 /* 242 */ "collate ::=",
 /* 243 */ "collate ::= COLLATE ids",
 /* 244 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 245 */ "cmd ::= VACUUM",
 /* 246 */ "cmd ::= VACUUM nm",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 249 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 250 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 251 */ "cmd ::= PRAGMA nm dbnm",
 /* 252 */ "nmnum ::= plus_num",
 /* 253 */ "nmnum ::= nm",
 /* 254 */ "plus_num ::= plus_opt number",
 /* 255 */ "minus_num ::= MINUS number",
 /* 256 */ "number ::= INTEGER|FLOAT",
 /* 257 */ "plus_opt ::= PLUS",
 /* 258 */ "plus_opt ::=",
 /* 259 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 260 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 261 */ "trigger_time ::= BEFORE",
 /* 262 */ "trigger_time ::= AFTER",
 /* 263 */ "trigger_time ::= INSTEAD OF",
 /* 264 */ "trigger_time ::=",
 /* 265 */ "trigger_event ::= DELETE|INSERT",
 /* 266 */ "trigger_event ::= UPDATE",
 /* 267 */ "trigger_event ::= UPDATE OF inscollist",
 /* 268 */ "foreach_clause ::=",
 /* 269 */ "foreach_clause ::= FOR EACH ROW",
 /* 270 */ "when_clause ::=",
 /* 271 */ "when_clause ::= WHEN expr",
 /* 272 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 273 */ "trigger_cmd_list ::=",
 /* 274 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 275 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 276 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 277 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 278 */ "trigger_cmd ::= select",
 /* 279 */ "expr ::= RAISE LP IGNORE RP",
 /* 280 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 281 */ "raisetype ::= ROLLBACK",
 /* 282 */ "raisetype ::= ABORT",
 /* 283 */ "raisetype ::= FAIL",
 /* 284 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 285 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 286 */ "cmd ::= DETACH database_kw_opt expr",
 /* 287 */ "key_opt ::=",
 /* 288 */ "key_opt ::= KEY expr",
 /* 289 */ "database_kw_opt ::= DATABASE",
 /* 290 */ "database_kw_opt ::=",
 /* 291 */ "cmd ::= REINDEX",
 /* 292 */ "cmd ::= REINDEX nm dbnm",
 /* 293 */ "cmd ::= ANALYZE",
 /* 294 */ "cmd ::= ANALYZE nm dbnm",
 /* 295 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 296 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 297 */ "add_column_fullname ::= fullname",
 /* 298 */ "kwcolumn_opt ::=",
 /* 299 */ "kwcolumn_opt ::= COLUMNKW",
 /* 300 */ "cmd ::= create_vtab",
 /* 301 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 302 */ "create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm",
 /* 303 */ "vtabarglist ::= vtabarg",
 /* 304 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 305 */ "vtabarg ::=",
 /* 306 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 307 */ "vtabargtoken ::= ANY",
 /* 308 */ "vtabargtoken ::= lp anylist RP",
 /* 309 */ "lp ::= LP",
 /* 310 */ "anylist ::=",
 /* 311 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 155:
    case 189:
    case 206:
#line 373 "parse.y"
{sqlite3SelectDelete((yypminor->yy219));}
#line 1302 "parse.c"
      break;
    case 169:
    case 170:
    case 194:
    case 196:
    case 204:
    case 210:
    case 218:
    case 221:
    case 223:
    case 235:
#line 633 "parse.y"
{sqlite3ExprDelete((yypminor->yy172));}
#line 1316 "parse.c"
      break;
    case 174:
    case 182:
    case 192:
    case 195:
    case 197:
    case 199:
    case 209:
    case 211:
    case 212:
    case 215:
    case 216:
    case 222:
#line 891 "parse.y"
{sqlite3ExprListDelete((yypminor->yy174));}
#line 1332 "parse.c"
      break;
    case 188:
    case 193:
    case 201:
    case 202:
#line 490 "parse.y"
{sqlite3SrcListDelete((yypminor->yy373));}
#line 1340 "parse.c"
      break;
    case 205:
    case 208:
    case 214:
#line 507 "parse.y"
{sqlite3IdListDelete((yypminor->yy432));}
#line 1347 "parse.c"
      break;
    case 231:
    case 236:
#line 994 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy243));}
#line 1353 "parse.c"
      break;
    case 233:
#line 980 "parse.y"
{sqlite3IdListDelete((yypminor->yy370).b);}
#line 1358 "parse.c"
      break;
    case 238:
#line 1067 "parse.y"
{sqlite3ExprDelete((yypminor->yy386));}
#line 1363 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3ParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 44 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1527 "parse.c"
   sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 139, 1 },
  { 140, 2 },
  { 140, 1 },
  { 142, 1 },
  { 141, 1 },
  { 141, 3 },
  { 144, 0 },
  { 144, 1 },
  { 144, 3 },
  { 143, 3 },
  { 146, 0 },
  { 146, 1 },
  { 146, 2 },
  { 145, 0 },
  { 145, 1 },
  { 145, 1 },
  { 145, 1 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 148, 6 },
  { 151, 0 },
  { 151, 3 },
  { 150, 1 },
  { 150, 0 },
  { 149, 4 },
  { 149, 2 },
  { 153, 3 },
  { 153, 1 },
  { 156, 3 },
  { 157, 1 },
  { 160, 1 },
  { 161, 1 },
  { 147, 1 },
  { 147, 1 },
  { 147, 1 },
  { 158, 0 },
  { 158, 1 },
  { 162, 1 },
  { 162, 4 },
  { 162, 6 },
  { 163, 1 },
  { 163, 2 },
  { 164, 1 },
  { 164, 1 },
  { 159, 2 },
  { 159, 0 },
  { 167, 3 },
  { 167, 1 },
  { 168, 2 },
  { 168, 4 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 168, 2 },
  { 168, 3 },
  { 168, 5 },
  { 168, 2 },
  { 168, 4 },
  { 168, 4 },
  { 168, 1 },
  { 168, 2 },
  { 173, 0 },
  { 173, 1 },
  { 175, 0 },
  { 175, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 178, 2 },
  { 178, 2 },
  { 178, 1 },
  { 178, 1 },
  { 176, 3 },
  { 176, 2 },
  { 179, 0 },
  { 179, 2 },
  { 179, 2 },
  { 154, 0 },
  { 154, 2 },
  { 180, 3 },
  { 180, 2 },
  { 180, 1 },
  { 181, 2 },
  { 181, 7 },
  { 181, 5 },
  { 181, 5 },
  { 181, 10 },
  { 183, 0 },
  { 183, 1 },
  { 171, 0 },
  { 171, 3 },
  { 184, 0 },
  { 184, 2 },
  { 185, 1 },
  { 185, 1 },
  { 185, 1 },
  { 143, 4 },
  { 187, 2 },
  { 187, 0 },
  { 143, 8 },
  { 143, 4 },
  { 143, 1 },
  { 155, 1 },
  { 155, 3 },
  { 190, 1 },
  { 190, 2 },
  { 190, 1 },
  { 189, 9 },
  { 191, 1 },
  { 191, 1 },
  { 191, 0 },
  { 199, 2 },
  { 199, 0 },
  { 192, 3 },
  { 192, 2 },
  { 192, 4 },
  { 200, 2 },
  { 200, 1 },
  { 200, 0 },
  { 193, 0 },
  { 193, 2 },
  { 202, 2 },
  { 202, 0 },
  { 201, 6 },
  { 201, 7 },
  { 206, 1 },
  { 206, 1 },
  { 152, 0 },
  { 152, 2 },
  { 188, 2 },
  { 203, 1 },
  { 203, 2 },
  { 203, 3 },
  { 203, 4 },
  { 204, 2 },
  { 204, 0 },
  { 205, 4 },
  { 205, 0 },
  { 197, 0 },
  { 197, 3 },
  { 209, 4 },
  { 209, 2 },
  { 210, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 0 },
  { 195, 0 },
  { 195, 3 },
  { 196, 0 },
  { 196, 2 },
  { 198, 0 },
  { 198, 2 },
  { 198, 4 },
  { 198, 4 },
  { 143, 4 },
  { 194, 0 },
  { 194, 2 },
  { 143, 6 },
  { 212, 5 },
  { 212, 3 },
  { 143, 8 },
  { 143, 5 },
  { 143, 6 },
  { 213, 2 },
  { 213, 1 },
  { 215, 3 },
  { 215, 1 },
  { 214, 0 },
  { 214, 3 },
  { 208, 3 },
  { 208, 1 },
  { 170, 1 },
  { 170, 3 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 5 },
  { 169, 1 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 6 },
  { 170, 5 },
  { 170, 4 },
  { 169, 1 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 217, 1 },
  { 217, 2 },
  { 217, 1 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 170, 4 },
  { 170, 2 },
  { 170, 3 },
  { 170, 3 },
  { 170, 4 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 219, 1 },
  { 219, 2 },
  { 170, 5 },
  { 220, 1 },
  { 220, 2 },
  { 170, 5 },
  { 170, 3 },
  { 170, 5 },
  { 170, 4 },
  { 170, 4 },
  { 170, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 216, 1 },
  { 216, 0 },
  { 211, 3 },
  { 211, 1 },
  { 143, 11 },
  { 224, 1 },
  { 224, 0 },
  { 174, 0 },
  { 174, 3 },
  { 182, 5 },
  { 182, 3 },
  { 225, 1 },
  { 226, 0 },
  { 226, 2 },
  { 143, 4 },
  { 143, 1 },
  { 143, 2 },
  { 143, 5 },
  { 143, 5 },
  { 143, 5 },
  { 143, 6 },
  { 143, 3 },
  { 227, 1 },
  { 227, 1 },
  { 165, 2 },
  { 166, 2 },
  { 229, 1 },
  { 228, 1 },
  { 228, 0 },
  { 143, 5 },
  { 230, 11 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 232, 0 },
  { 233, 1 },
  { 233, 1 },
  { 233, 3 },
  { 234, 0 },
  { 234, 3 },
  { 235, 0 },
  { 235, 2 },
  { 231, 3 },
  { 231, 0 },
  { 236, 6 },
  { 236, 8 },
  { 236, 5 },
  { 236, 4 },
  { 236, 1 },
  { 170, 4 },
  { 170, 6 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 143, 4 },
  { 143, 6 },
  { 143, 3 },
  { 238, 0 },
  { 238, 2 },
  { 237, 1 },
  { 237, 0 },
  { 143, 1 },
  { 143, 3 },
  { 143, 1 },
  { 143, 3 },
  { 143, 6 },
  { 143, 6 },
  { 239, 1 },
  { 240, 0 },
  { 240, 1 },
  { 143, 1 },
  { 143, 4 },
  { 241, 7 },
  { 242, 1 },
  { 242, 3 },
  { 243, 0 },
  { 243, 2 },
  { 244, 1 },
  { 244, 3 },
  { 245, 1 },
  { 246, 0 },
  { 246, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  memset(&yygotominor, 0, sizeof(yygotominor));


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
      case 1:
      case 2:
      case 4:
      case 5:
      case 10:
      case 11:
      case 12:
      case 20:
      case 28:
      case 29:
      case 37:
      case 44:
      case 45:
      case 46:
      case 47:
      case 48:
      case 49:
      case 55:
      case 82:
      case 83:
      case 84:
      case 85:
      case 257:
      case 258:
      case 268:
      case 269:
      case 289:
      case 290:
      case 298:
      case 299:
      case 303:
      case 304:
      case 306:
      case 310:
#line 96 "parse.y"
{
}
#line 1982 "parse.c"
        break;
      case 3:
#line 99 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1987 "parse.c"
        break;
      case 6:
#line 102 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1992 "parse.c"
        break;
      case 7:
#line 104 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1997 "parse.c"
        break;
      case 8:
#line 105 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 2002 "parse.c"
        break;
      case 9:
#line 111 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy46);}
#line 2007 "parse.c"
        break;
      case 13:
#line 116 "parse.y"
{yygotominor.yy46 = TK_DEFERRED;}
#line 2012 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 117 "parse.y"
{yygotominor.yy46 = yymsp[0].major;}
#line 2021 "parse.c"
        break;
      case 17:
      case 18:
#line 120 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 2027 "parse.c"
        break;
      case 19:
#line 122 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 2032 "parse.c"
        break;
      case 21:
#line 127 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,yymsp[-4].minor.yy46,0,0,yymsp[-2].minor.yy46);
}
#line 2039 "parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 213:
      case 216:
#line 131 "parse.y"
{yygotominor.yy46 = 0;}
#line 2054 "parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 214:
      case 217:
#line 132 "parse.y"
{yygotominor.yy46 = 1;}
#line 2066 "parse.c"
        break;
      case 26:
#line 138 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy0,0);
}
#line 2073 "parse.c"
        break;
      case 27:
#line 141 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy219);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 2081 "parse.c"
        break;
      case 30:
#line 153 "parse.y"
{
  yygotominor.yy410.z = yymsp[-2].minor.yy410.z;
  yygotominor.yy410.n = (pParse->sLastToken.z-yymsp[-2].minor.yy410.z) + pParse->sLastToken.n;
}
#line 2089 "parse.c"
        break;
      case 31:
#line 157 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy410);
  yygotominor.yy410 = yymsp[0].minor.yy410;
}
#line 2097 "parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 256:
#line 167 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy0;}
#line 2107 "parse.c"
        break;
      case 38:
#line 228 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy410);}
#line 2112 "parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 241:
      case 243:
      case 252:
      case 253:
      case 254:
      case 255:
#line 229 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy410;}
#line 2127 "parse.c"
        break;
      case 40:
#line 230 "parse.y"
{
  yygotominor.yy410.z = yymsp[-3].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy410.z;
}
#line 2135 "parse.c"
        break;
      case 41:
#line 234 "parse.y"
{
  yygotominor.yy410.z = yymsp[-5].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy410.z;
}
#line 2143 "parse.c"
        break;
      case 43:
#line 240 "parse.y"
{yygotominor.yy410.z=yymsp[-1].minor.yy410.z; yygotominor.yy410.n=yymsp[0].minor.yy410.n+(yymsp[0].minor.yy410.z-yymsp[-1].minor.yy410.z);}
#line 2148 "parse.c"
        break;
      case 50:
      case 52:
#line 251 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy172);}
#line 2154 "parse.c"
        break;
      case 51:
#line 252 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy172);}
#line 2159 "parse.c"
        break;
      case 53:
#line 254 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2167 "parse.c"
        break;
      case 54:
#line 258 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_STRING, 0, 0, &yymsp[0].minor.yy410);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2175 "parse.c"
        break;
      case 56:
#line 267 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy46);}
#line 2180 "parse.c"
        break;
      case 57:
#line 269 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy46,yymsp[0].minor.yy46,yymsp[-2].minor.yy46);}
#line 2185 "parse.c"
        break;
      case 58:
#line 270 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy46,0,0,0,0);}
#line 2190 "parse.c"
        break;
      case 59:
#line 271 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy172);}
#line 2195 "parse.c"
        break;
      case 60:
#line 273 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy410,yymsp[-1].minor.yy174,yymsp[0].minor.yy46);}
#line 2200 "parse.c"
        break;
      case 61:
#line 274 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy46);}
#line 2205 "parse.c"
        break;
      case 62:
#line 275 "parse.y"
{sqlite3AddCollateType(pParse, &yymsp[0].minor.yy410);}
#line 2210 "parse.c"
        break;
      case 65:
#line 288 "parse.y"
{ yygotominor.yy46 = OE_Restrict * 0x010101; }
#line 2215 "parse.c"
        break;
      case 66:
#line 289 "parse.y"
{ yygotominor.yy46 = (yymsp[-1].minor.yy46 & yymsp[0].minor.yy405.mask) | yymsp[0].minor.yy405.value; }
#line 2220 "parse.c"
        break;
      case 67:
#line 291 "parse.y"
{ yygotominor.yy405.value = 0;     yygotominor.yy405.mask = 0x000000; }
#line 2225 "parse.c"
        break;
      case 68:
#line 292 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46;     yygotominor.yy405.mask = 0x0000ff; }
#line 2230 "parse.c"
        break;
      case 69:
#line 293 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<8;  yygotominor.yy405.mask = 0x00ff00; }
#line 2235 "parse.c"
        break;
      case 70:
#line 294 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<16; yygotominor.yy405.mask = 0xff0000; }
#line 2240 "parse.c"
        break;
      case 71:
#line 296 "parse.y"
{ yygotominor.yy46 = OE_SetNull; }
#line 2245 "parse.c"
        break;
      case 72:
#line 297 "parse.y"
{ yygotominor.yy46 = OE_SetDflt; }
#line 2250 "parse.c"
        break;
      case 73:
#line 298 "parse.y"
{ yygotominor.yy46 = OE_Cascade; }
#line 2255 "parse.c"
        break;
      case 74:
#line 299 "parse.y"
{ yygotominor.yy46 = OE_Restrict; }
#line 2260 "parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 166:
#line 301 "parse.y"
{yygotominor.yy46 = yymsp[0].minor.yy46;}
#line 2271 "parse.c"
        break;
      case 80:
#line 311 "parse.y"
{yygotominor.yy410.n = 0; yygotominor.yy410.z = 0;}
#line 2276 "parse.c"
        break;
      case 81:
#line 312 "parse.y"
{yygotominor.yy410 = yymsp[-1].minor.yy0;}
#line 2281 "parse.c"
        break;
      case 86:
#line 318 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy174,yymsp[0].minor.yy46,yymsp[-2].minor.yy46,0);}
#line 2286 "parse.c"
        break;
      case 87:
#line 320 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy174,yymsp[0].minor.yy46,0,0,0,0);}
#line 2291 "parse.c"
        break;
      case 88:
#line 321 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy172);}
#line 2296 "parse.c"
        break;
      case 89:
#line 323 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy174, &yymsp[-3].minor.yy410, yymsp[-2].minor.yy174, yymsp[-1].minor.yy46);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy46);
}
#line 2304 "parse.c"
        break;
      case 92:
      case 94:
#line 337 "parse.y"
{yygotominor.yy46 = OE_Default;}
#line 2310 "parse.c"
        break;
      case 97:
#line 342 "parse.y"
{yygotominor.yy46 = OE_Ignore;}
#line 2315 "parse.c"
        break;
      case 98:
      case 167:
#line 343 "parse.y"
{yygotominor.yy46 = OE_Replace;}
#line 2321 "parse.c"
        break;
      case 99:
#line 347 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 0, yymsp[-1].minor.yy46);
}
#line 2328 "parse.c"
        break;
      case 102:
#line 357 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, yymsp[0].minor.yy219, yymsp[-6].minor.yy46, yymsp[-4].minor.yy46);
}
#line 2335 "parse.c"
        break;
      case 103:
#line 360 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 1, yymsp[-1].minor.yy46);
}
#line 2342 "parse.c"
        break;
      case 104:
#line 367 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy219, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 2350 "parse.c"
        break;
      case 105:
      case 128:
#line 377 "parse.y"
{yygotominor.yy219 = yymsp[0].minor.yy219;}
#line 2356 "parse.c"
        break;
      case 106:
#line 379 "parse.y"
{
  if( yymsp[0].minor.yy219 ){
    yymsp[0].minor.yy219->op = yymsp[-1].minor.yy46;
    yymsp[0].minor.yy219->pPrior = yymsp[-2].minor.yy219;
  }else{
    sqlite3SelectDelete(yymsp[-2].minor.yy219);
  }
  yygotominor.yy219 = yymsp[0].minor.yy219;
}
#line 2369 "parse.c"
        break;
      case 108:
#line 390 "parse.y"
{yygotominor.yy46 = TK_ALL;}
#line 2374 "parse.c"
        break;
      case 110:
#line 394 "parse.y"
{
  yygotominor.yy219 = sqlite3SelectNew(pParse,yymsp[-6].minor.yy174,yymsp[-5].minor.yy373,yymsp[-4].minor.yy172,yymsp[-3].minor.yy174,yymsp[-2].minor.yy172,yymsp[-1].minor.yy174,yymsp[-7].minor.yy46,yymsp[0].minor.yy234.pLimit,yymsp[0].minor.yy234.pOffset);
}
#line 2381 "parse.c"
        break;
      case 114:
      case 238:
#line 415 "parse.y"
{yygotominor.yy174 = yymsp[-1].minor.yy174;}
#line 2387 "parse.c"
        break;
      case 115:
      case 141:
      case 149:
      case 231:
      case 237:
#line 416 "parse.y"
{yygotominor.yy174 = 0;}
#line 2396 "parse.c"
        break;
      case 116:
#line 417 "parse.y"
{
   yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy174,yymsp[-1].minor.yy172,yymsp[0].minor.yy410.n?&yymsp[0].minor.yy410:0);
}
#line 2403 "parse.c"
        break;
      case 117:
#line 420 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_ALL, 0, 0, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse, yymsp[-1].minor.yy174, p, 0);
}
#line 2411 "parse.c"
        break;
      case 118:
#line 424 "parse.y"
{
  Expr *pRight = sqlite3PExpr(pParse, TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *pDot = sqlite3PExpr(pParse, TK_DOT, pLeft, pRight, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy174, pDot, 0);
}
#line 2421 "parse.c"
        break;
      case 121:
#line 437 "parse.y"
{yygotominor.yy410.n = 0;}
#line 2426 "parse.c"
        break;
      case 122:
#line 449 "parse.y"
{yygotominor.yy373 = (SrcList*)sqlite3DbMallocZero(pParse->db, sizeof(*yygotominor.yy373));}
#line 2431 "parse.c"
        break;
      case 123:
#line 450 "parse.y"
{
  yygotominor.yy373 = yymsp[0].minor.yy373;
  sqlite3SrcListShiftJoinType(yygotominor.yy373);
}
#line 2439 "parse.c"
        break;
      case 124:
#line 458 "parse.y"
{
   yygotominor.yy373 = yymsp[-1].minor.yy373;
   if( yygotominor.yy373 && yygotominor.yy373->nSrc>0 ) yygotominor.yy373->a[yygotominor.yy373->nSrc-1].jointype = yymsp[0].minor.yy46;
}
#line 2447 "parse.c"
        break;
      case 125:
#line 462 "parse.y"
{yygotominor.yy373 = 0;}
#line 2452 "parse.c"
        break;
      case 126:
#line 463 "parse.y"
{
  yygotominor.yy373 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-5].minor.yy373,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,0,yymsp[-1].minor.yy172,yymsp[0].minor.yy432);
}
#line 2459 "parse.c"
        break;
      case 127:
#line 468 "parse.y"
{
    yygotominor.yy373 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy373,0,0,&yymsp[-2].minor.yy410,yymsp[-4].minor.yy219,yymsp[-1].minor.yy172,yymsp[0].minor.yy432);
  }
#line 2466 "parse.c"
        break;
      case 129:
#line 479 "parse.y"
{
     sqlite3SrcListShiftJoinType(yymsp[0].minor.yy373);
     yygotominor.yy219 = sqlite3SelectNew(pParse,0,yymsp[0].minor.yy373,0,0,0,0,0,0,0);
  }
#line 2474 "parse.c"
        break;
      case 130:
#line 486 "parse.y"
{yygotominor.yy410.z=0; yygotominor.yy410.n=0;}
#line 2479 "parse.c"
        break;
      case 132:
#line 491 "parse.y"
{yygotominor.yy373 = sqlite3SrcListAppend(pParse->db,0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);}
#line 2484 "parse.c"
        break;
      case 133:
#line 495 "parse.y"
{ yygotominor.yy46 = JT_INNER; }
#line 2489 "parse.c"
        break;
      case 134:
#line 496 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2494 "parse.c"
        break;
      case 135:
#line 497 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy410,0); }
#line 2499 "parse.c"
        break;
      case 136:
#line 499 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy410,&yymsp[-1].minor.yy410); }
#line 2504 "parse.c"
        break;
      case 137:
      case 145:
      case 152:
      case 159:
      case 174:
      case 202:
      case 226:
      case 228:
#line 503 "parse.y"
{yygotominor.yy172 = yymsp[0].minor.yy172;}
#line 2516 "parse.c"
        break;
      case 138:
      case 151:
      case 158:
      case 203:
      case 227:
      case 229:
#line 504 "parse.y"
{yygotominor.yy172 = 0;}
#line 2526 "parse.c"
        break;
      case 139:
      case 171:
#line 508 "parse.y"
{yygotominor.yy432 = yymsp[-1].minor.yy432;}
#line 2532 "parse.c"
        break;
      case 140:
      case 170:
#line 509 "parse.y"
{yygotominor.yy432 = 0;}
#line 2538 "parse.c"
        break;
      case 142:
      case 150:
      case 230:
#line 520 "parse.y"
{yygotominor.yy174 = yymsp[0].minor.yy174;}
#line 2545 "parse.c"
        break;
      case 143:
#line 521 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy174,yymsp[-1].minor.yy172,0);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2553 "parse.c"
        break;
      case 144:
#line 525 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,0,yymsp[-1].minor.yy172,0);
  if( yygotominor.yy174 && yygotominor.yy174->a ) yygotominor.yy174->a[0].sortOrder = yymsp[0].minor.yy46;
}
#line 2561 "parse.c"
        break;
      case 146:
      case 148:
#line 533 "parse.y"
{yygotominor.yy46 = SQLITE_SO_ASC;}
#line 2567 "parse.c"
        break;
      case 147:
#line 534 "parse.y"
{yygotominor.yy46 = SQLITE_SO_DESC;}
#line 2572 "parse.c"
        break;
      case 153:
#line 560 "parse.y"
{yygotominor.yy234.pLimit = 0; yygotominor.yy234.pOffset = 0;}
#line 2577 "parse.c"
        break;
      case 154:
#line 561 "parse.y"
{yygotominor.yy234.pLimit = yymsp[0].minor.yy172; yygotominor.yy234.pOffset = 0;}
#line 2582 "parse.c"
        break;
      case 155:
#line 563 "parse.y"
{yygotominor.yy234.pLimit = yymsp[-2].minor.yy172; yygotominor.yy234.pOffset = yymsp[0].minor.yy172;}
#line 2587 "parse.c"
        break;
      case 156:
#line 565 "parse.y"
{yygotominor.yy234.pOffset = yymsp[-2].minor.yy172; yygotominor.yy234.pLimit = yymsp[0].minor.yy172;}
#line 2592 "parse.c"
        break;
      case 157:
#line 569 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy373,yymsp[0].minor.yy172);}
#line 2597 "parse.c"
        break;
      case 160:
#line 579 "parse.y"
{
  sqlite3ExprListCheckLength(pParse,yymsp[-1].minor.yy174,SQLITE_MAX_COLUMN,"set list"); 
  sqlite3Update(pParse,yymsp[-3].minor.yy373,yymsp[-1].minor.yy174,yymsp[0].minor.yy172,yymsp[-4].minor.yy46);
}
#line 2605 "parse.c"
        break;
      case 161:
#line 588 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy174,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2610 "parse.c"
        break;
      case 162:
#line 590 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2615 "parse.c"
        break;
      case 163:
#line 596 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy373, yymsp[-1].minor.yy174, 0, yymsp[-4].minor.yy432, yymsp[-7].minor.yy46);}
#line 2620 "parse.c"
        break;
      case 164:
#line 598 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy373, 0, yymsp[0].minor.yy219, yymsp[-1].minor.yy432, yymsp[-4].minor.yy46);}
#line 2625 "parse.c"
        break;
      case 165:
#line 600 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy373, 0, 0, yymsp[-2].minor.yy432, yymsp[-5].minor.yy46);}
#line 2630 "parse.c"
        break;
      case 168:
      case 232:
#line 611 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy174,yymsp[0].minor.yy172,0);}
#line 2636 "parse.c"
        break;
      case 169:
      case 233:
#line 613 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy172,0);}
#line 2642 "parse.c"
        break;
      case 172:
#line 623 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(pParse->db,yymsp[-2].minor.yy432,&yymsp[0].minor.yy410);}
#line 2647 "parse.c"
        break;
      case 173:
#line 625 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(pParse->db,0,&yymsp[0].minor.yy410);}
#line 2652 "parse.c"
        break;
      case 175:
#line 636 "parse.y"
{yygotominor.yy172 = yymsp[-1].minor.yy172; sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2657 "parse.c"
        break;
      case 176:
      case 181:
      case 182:
#line 637 "parse.y"
{yygotominor.yy172 = sqlite3PExpr(pParse, yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2664 "parse.c"
        break;
      case 177:
      case 178:
#line 638 "parse.y"
{yygotominor.yy172 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2670 "parse.c"
        break;
      case 179:
#line 640 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy410);
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_DOT, temp1, temp2, 0);
}
#line 2679 "parse.c"
        break;
      case 180:
#line 645 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-4].minor.yy410);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp3 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy410);
  Expr *temp4 = sqlite3PExpr(pParse, TK_DOT, temp2, temp3, 0);
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_DOT, temp1, temp4, 0);
}
#line 2690 "parse.c"
        break;
      case 183:
#line 654 "parse.y"
{yygotominor.yy172 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2695 "parse.c"
        break;
      case 184:
#line 655 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy172 = sqlite3PExpr(pParse, TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2704 "parse.c"
        break;
      case 185:
#line 660 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy172, &yymsp[0].minor.yy410);
}
#line 2711 "parse.c"
        break;
      case 186:
#line 664 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_CAST, yymsp[-3].minor.yy172, 0, &yymsp[-1].minor.yy410);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2719 "parse.c"
        break;
      case 187:
#line 669 "parse.y"
{
  if( yymsp[-1].minor.yy174 && yymsp[-1].minor.yy174->nExpr>SQLITE_MAX_FUNCTION_ARG ){
    sqlite3ErrorMsg(pParse, "too many arguments on function %T", &yymsp[-4].minor.yy0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(pParse, yymsp[-1].minor.yy174, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy46 && yygotominor.yy172 ){
    yygotominor.yy172->flags |= EP_Distinct;
  }
}
#line 2733 "parse.c"
        break;
      case 188:
#line 679 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprFunction(pParse, 0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2741 "parse.c"
        break;
      case 189:
#line 683 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy172 = sqlite3ExprFunction(pParse, 0,&yymsp[0].minor.yy0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->op = TK_CONST_FUNC;  
    yygotominor.yy172->span = yymsp[0].minor.yy0;
  }
}
#line 2754 "parse.c"
        break;
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
#line 692 "parse.y"
{yygotominor.yy172 = sqlite3PExpr(pParse,yymsp[-1].major,yymsp[-2].minor.yy172,yymsp[0].minor.yy172,0);}
#line 2766 "parse.c"
        break;
      case 198:
      case 200:
#line 704 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.notValue = 0;}
#line 2772 "parse.c"
        break;
      case 199:
      case 201:
#line 705 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.notValue = 1;}
#line 2778 "parse.c"
        break;
      case 204:
#line 712 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(pParse,0, yymsp[-1].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[-3].minor.yy172, 0);
  if( yymsp[0].minor.yy172 ){
    pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy172, 0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(pParse, pList, &yymsp[-2].minor.yy72.eOperator);
  if( yymsp[-2].minor.yy72.notValue ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy172->span, &yymsp[-1].minor.yy172->span);
  if( yygotominor.yy172 ) yygotominor.yy172->flags |= EP_InfixFunc;
}
#line 2794 "parse.c"
        break;
      case 205:
#line 725 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, yymsp[0].major, yymsp[-1].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2802 "parse.c"
        break;
      case 206:
#line 729 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_ISNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2810 "parse.c"
        break;
      case 207:
#line 733 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2818 "parse.c"
        break;
      case 208:
#line 737 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-3].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2826 "parse.c"
        break;
      case 209:
      case 210:
#line 741 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, yymsp[-1].major, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2835 "parse.c"
        break;
      case 211:
#line 749 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2843 "parse.c"
        break;
      case 212:
#line 753 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_UPLUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2851 "parse.c"
        break;
      case 215:
#line 760 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy172, 0);
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_BETWEEN, yymsp[-4].minor.yy172, 0, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy172->span);
}
#line 2867 "parse.c"
        break;
      case 218:
#line 776 "parse.y"
{
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pList = yymsp[-1].minor.yy174;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy174);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2882 "parse.c"
        break;
      case 219:
#line 787 "parse.y"
{
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_SELECT, 0, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2896 "parse.c"
        break;
      case 220:
#line 797 "parse.y"
{
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2911 "parse.c"
        break;
      case 221:
#line 808 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(pParse->db, 0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_IN, yymsp[-3].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = sqlite3SelectNew(pParse, 0,pSrc,0,0,0,0,0,0,0);
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,yymsp[0].minor.yy410.z?&yymsp[0].minor.yy410:&yymsp[-1].minor.yy410);
  }
#line 2927 "parse.c"
        break;
      case 222:
#line 820 "parse.y"
{
    Expr *p = yygotominor.yy172 = sqlite3PExpr(pParse, TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
  }
#line 2941 "parse.c"
        break;
      case 223:
#line 833 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_CASE, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = yymsp[-2].minor.yy174;
    sqlite3ExprSetHeight(yygotominor.yy172);
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy174);
  }
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2955 "parse.c"
        break;
      case 224:
#line 845 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy174, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2963 "parse.c"
        break;
      case 225:
#line 849 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2971 "parse.c"
        break;
      case 234:
#line 878 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy410, &yymsp[-5].minor.yy410, 
                     sqlite3SrcListAppend(pParse->db,0,&yymsp[-3].minor.yy410,0), yymsp[-1].minor.yy174, yymsp[-9].minor.yy46,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy46);
}
#line 2980 "parse.c"
        break;
      case 235:
      case 282:
#line 885 "parse.y"
{yygotominor.yy46 = OE_Abort;}
#line 2986 "parse.c"
        break;
      case 236:
#line 886 "parse.y"
{yygotominor.yy46 = OE_None;}
#line 2991 "parse.c"
        break;
      case 239:
#line 896 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy410);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy174, p, &yymsp[-2].minor.yy410);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy174, SQLITE_MAX_COLUMN, "index");
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 3005 "parse.c"
        break;
      case 240:
#line 906 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy410);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,0, p, &yymsp[-2].minor.yy410);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy174, SQLITE_MAX_COLUMN, "index");
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 3019 "parse.c"
        break;
      case 242:
#line 919 "parse.y"
{yygotominor.yy410.z = 0; yygotominor.yy410.n = 0;}
#line 3024 "parse.c"
        break;
      case 244:
#line 925 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy373, yymsp[-1].minor.yy46);}
#line 3029 "parse.c"
        break;
      case 245:
      case 246:
#line 931 "parse.y"
{sqlite3Vacuum(pParse);}
#line 3035 "parse.c"
        break;
      case 247:
#line 939 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,0);}
#line 3040 "parse.c"
        break;
      case 248:
#line 940 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy0,0);}
#line 3045 "parse.c"
        break;
      case 249:
#line 941 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,1);
}
#line 3052 "parse.c"
        break;
      case 250:
#line 944 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-1].minor.yy410,0);}
#line 3057 "parse.c"
        break;
      case 251:
#line 945 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,0,0);}
#line 3062 "parse.c"
        break;
      case 259:
#line 959 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy410.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy410.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy243, &all);
}
#line 3072 "parse.c"
        break;
      case 260:
#line 968 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy410, &yymsp[-6].minor.yy410, yymsp[-5].minor.yy46, yymsp[-4].minor.yy370.a, yymsp[-4].minor.yy370.b, yymsp[-2].minor.yy373, yymsp[0].minor.yy172, yymsp[-10].minor.yy46, yymsp[-8].minor.yy46);
  yygotominor.yy410 = (yymsp[-6].minor.yy410.n==0?yymsp[-7].minor.yy410:yymsp[-6].minor.yy410);
}
#line 3080 "parse.c"
        break;
      case 261:
      case 264:
#line 974 "parse.y"
{ yygotominor.yy46 = TK_BEFORE; }
#line 3086 "parse.c"
        break;
      case 262:
#line 975 "parse.y"
{ yygotominor.yy46 = TK_AFTER;  }
#line 3091 "parse.c"
        break;
      case 263:
#line 976 "parse.y"
{ yygotominor.yy46 = TK_INSTEAD;}
#line 3096 "parse.c"
        break;
      case 265:
      case 266:
#line 981 "parse.y"
{yygotominor.yy370.a = yymsp[0].major; yygotominor.yy370.b = 0;}
#line 3102 "parse.c"
        break;
      case 267:
#line 983 "parse.y"
{yygotominor.yy370.a = TK_UPDATE; yygotominor.yy370.b = yymsp[0].minor.yy432;}
#line 3107 "parse.c"
        break;
      case 270:
#line 990 "parse.y"
{ yygotominor.yy172 = 0; }
#line 3112 "parse.c"
        break;
      case 271:
#line 991 "parse.y"
{ yygotominor.yy172 = yymsp[0].minor.yy172; }
#line 3117 "parse.c"
        break;
      case 272:
#line 995 "parse.y"
{
  if( yymsp[-2].minor.yy243 ){
    yymsp[-2].minor.yy243->pLast->pNext = yymsp[-1].minor.yy243;
  }else{
    yymsp[-2].minor.yy243 = yymsp[-1].minor.yy243;
  }
  yymsp[-2].minor.yy243->pLast = yymsp[-1].minor.yy243;
  yygotominor.yy243 = yymsp[-2].minor.yy243;
}
#line 3130 "parse.c"
        break;
      case 273:
#line 1004 "parse.y"
{ yygotominor.yy243 = 0; }
#line 3135 "parse.c"
        break;
      case 274:
#line 1010 "parse.y"
{ yygotominor.yy243 = sqlite3TriggerUpdateStep(pParse->db, &yymsp[-3].minor.yy410, yymsp[-1].minor.yy174, yymsp[0].minor.yy172, yymsp[-4].minor.yy46); }
#line 3140 "parse.c"
        break;
      case 275:
#line 1015 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-5].minor.yy410, yymsp[-4].minor.yy432, yymsp[-1].minor.yy174, 0, yymsp[-7].minor.yy46);}
#line 3145 "parse.c"
        break;
      case 276:
#line 1018 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-2].minor.yy410, yymsp[-1].minor.yy432, 0, yymsp[0].minor.yy219, yymsp[-4].minor.yy46);}
#line 3150 "parse.c"
        break;
      case 277:
#line 1022 "parse.y"
{yygotominor.yy243 = sqlite3TriggerDeleteStep(pParse->db, &yymsp[-1].minor.yy410, yymsp[0].minor.yy172);}
#line 3155 "parse.c"
        break;
      case 278:
#line 1025 "parse.y"
{yygotominor.yy243 = sqlite3TriggerSelectStep(pParse->db, yymsp[0].minor.yy219); }
#line 3160 "parse.c"
        break;
      case 279:
#line 1028 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy172 ){
    yygotominor.yy172->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3171 "parse.c"
        break;
      case 280:
#line 1035 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, &yymsp[-1].minor.yy410); 
  if( yygotominor.yy172 ) {
    yygotominor.yy172->iColumn = yymsp[-3].minor.yy46;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3182 "parse.c"
        break;
      case 281:
#line 1045 "parse.y"
{yygotominor.yy46 = OE_Rollback;}
#line 3187 "parse.c"
        break;
      case 283:
#line 1047 "parse.y"
{yygotominor.yy46 = OE_Fail;}
#line 3192 "parse.c"
        break;
      case 284:
#line 1052 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy373,yymsp[-1].minor.yy46);
}
#line 3199 "parse.c"
        break;
      case 285:
#line 1059 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, yymsp[0].minor.yy386);
}
#line 3206 "parse.c"
        break;
      case 286:
#line 1062 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy172);
}
#line 3213 "parse.c"
        break;
      case 287:
#line 1068 "parse.y"
{ yygotominor.yy386 = 0; }
#line 3218 "parse.c"
        break;
      case 288:
#line 1069 "parse.y"
{ yygotominor.yy386 = yymsp[0].minor.yy172; }
#line 3223 "parse.c"
        break;
      case 291:
#line 1077 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3228 "parse.c"
        break;
      case 292:
#line 1078 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3233 "parse.c"
        break;
      case 293:
#line 1083 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3238 "parse.c"
        break;
      case 294:
#line 1084 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3243 "parse.c"
        break;
      case 295:
#line 1089 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy373,&yymsp[0].minor.yy410);
}
#line 3250 "parse.c"
        break;
      case 296:
#line 1092 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy410);
}
#line 3257 "parse.c"
        break;
      case 297:
#line 1095 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy373);
}
#line 3264 "parse.c"
        break;
      case 300:
#line 1104 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3269 "parse.c"
        break;
      case 301:
#line 1105 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3274 "parse.c"
        break;
      case 302:
#line 1106 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, &yymsp[0].minor.yy410);
}
#line 3281 "parse.c"
        break;
      case 305:
#line 1111 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3286 "parse.c"
        break;
      case 307:
      case 308:
      case 309:
      case 311:
#line 1113 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3294 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( !pParse->parseError ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
    pParse->parseError = 1;
  }
#line 3362 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      memset(&yyminorunion, 0, sizeof(yyminorunion));
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
