/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Monitors file creations, modifications and deletions.
*
*/
// Created by TraceCompiler 2.3.0
// DO NOT EDIT, CHANGES WILL BE LOST

#ifndef __FASTFINDFILESERVERPLUGINTRACES_H__
#define __FASTFINDFILESERVERPLUGINTRACES_H__

#define KOstTraceComponentID 0x2001f6fa

#define CFASTFINDFILESERVERPLUGIN_CFASTFINDFILESERVERPLUGIN 0x860001
#define DUP1_CFASTFINDFILESERVERPLUGIN_CFASTFINDFILESERVERPLUGIN 0x860002
#define CFASTFINDFILESERVERPLUGIN_NEWL 0x860003
#define CFASTFINDFILESERVERPLUGIN_INITIALISEL 0x860004
#define CFASTFINDFILESERVERPLUGIN_ENABLEL 0x860005
#define CFASTFINDFILESERVERPLUGIN_DISABLEL 0x860006
#define CFASTFINDFILESERVERPLUGIN_ADDCONNECTION 0x860007
#define CFASTFINDFILESERVERPLUGIN_REMOVECONNECTION 0x860008
#define DUP1_CFASTFINDFILESERVERPLUGIN_REMOVECONNECTION 0x860009
#define CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x86000a
#define DUP1_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x86000b
#define DUP2_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x86000c
#define DUP3_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x86000d
#define DUP4_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x86000e
#define DUP5_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x86000f
#define DUP6_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x860010
#define DUP7_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x860011
#define DUP8_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x860012
#define DUP9_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x860013
#define DUP10_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x860014
#define DUP11_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x860015
#define DUP12_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x860016
#define DUP13_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x860017
#define DUP14_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x860018
#define DUP15_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x860019
#define DUP16_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x86001a
#define DUP17_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x86001b
#define DUP18_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x86001c
#define DUP19_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x86001d
#define DUP20_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x86001e
#define DUP21_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x86001f
#define DUP22_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x860020
#define DUP23_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x860021
#define DUP24_CFASTFINDFILESERVERPLUGIN_DOREQUESTL 0x860022
#define CFASTFINDFILESERVERPLUGINCONN_NEWL 0x860023
#define CFASTFINDFILESERVERPLUGINCONN_CFASTFINDFILESERVERPLUGINCONN 0x860024
#define DUP1_CFASTFINDFILESERVERPLUGINCONN_CFASTFINDFILESERVERPLUGINCONN 0x860025
#define CFASTFINDFILESERVERPLUGINCONN_DOCONTROL 0x860026
#define DUP1_CFASTFINDFILESERVERPLUGINCONN_DOCONTROL 0x860027
#define DUP2_CFASTFINDFILESERVERPLUGINCONN_DOCONTROL 0x860028
#define DUP3_CFASTFINDFILESERVERPLUGINCONN_DOCONTROL 0x860029
#define CFASTFINDFILESERVERPLUGINCONN_DOREQUEST 0x86002a
#define DUP1_CFASTFINDFILESERVERPLUGINCONN_DOREQUEST 0x86002b
#define DUP2_CFASTFINDFILESERVERPLUGINCONN_DOREQUEST 0x86002c
#define DUP3_CFASTFINDFILESERVERPLUGINCONN_DOREQUEST 0x86002d
#define DUP4_CFASTFINDFILESERVERPLUGINCONN_DOREQUEST 0x86002e
#define CFASTFINDFILESERVERPLUGINCONN_DOCANCEL 0x86002f
#define CFASTFINDFILESERVERPLUGIN_NEWPLUGINCONNL 0x860030
#define CFASTFINDFILESERVERPLUGIN_REGISTERNOTIFICATION 0x860031
#define DUP1_CFASTFINDFILESERVERPLUGIN_REGISTERNOTIFICATION 0x860032
#define CFASTFINDFILESERVERPLUGIN_ADDNOTIFICATIONPATH 0x860033
#define DUP1_CFASTFINDFILESERVERPLUGIN_ADDNOTIFICATIONPATH 0x860034
#define CFASTFINDFILESERVERPLUGIN_REMOVENOTIFICATIONPATH 0x860035
#define CFASTFINDFILESERVERPLUGIN_ADDIGNOREPATH 0x860036
#define CFASTFINDFILESERVERPLUGIN_REMOVEIGNOREPATH 0x860037
#define CFASTFINDFILESERVERPLUGINFACTORY_CFASTFINDFILESERVERPLUGINFACTORY 0x860038
#define CFASTFINDFILESERVERPLUGINFACTORY_INSTALL 0x860039
#define CFASTFINDFILESERVERPLUGINFACTORY_UNIQUEPOSITION 0x86003a
#define CFASTFINDFILESERVERPLUGINFACTORY_NEWPLUGINL 0x86003b
#define DUP1_CFASTFINDFILESERVERPLUGINFACTORY_NEWPLUGINL 0x86003c
#define CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x86003d
#define DUP1_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x86003e
#define DUP2_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x86003f
#define DUP3_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860040
#define DUP4_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860041
#define DUP5_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860042
#define DUP6_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860043
#define DUP7_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860044
#define DUP8_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860045
#define DUP9_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860046
#define DUP10_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860047
#define DUP11_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860048
#define DUP12_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860049
#define DUP13_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x86004a
#define DUP14_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x86004b
#define DUP15_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x86004c
#define DUP16_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x86004d
#define DUP17_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x86004e
#define DUP18_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x86004f
#define DUP19_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860050
#define DUP20_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860051
#define DUP21_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860052
#define DUP22_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860053
#define DUP23_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860054
#define DUP24_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860055
#define DUP25_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860056
#define DUP26_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860057
#define DUP27_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860058
#define DUP28_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x860059
#define DUP29_CFASTFINDFILESERVERPLUGIN_PRINTDEBUGEVENTS 0x86005a
#define CFASTFINDFILESERVERPLUGIN_DOREQUESTL_ENTRY 0x8a0001
#define CFASTFINDFILESERVERPLUGIN_DOREQUESTL_EXIT 0x8a0002
#define DUP1_CFASTFINDFILESERVERPLUGIN_DOREQUESTL_EXIT 0x8a0003
#define DUP2_CFASTFINDFILESERVERPLUGIN_DOREQUESTL_EXIT 0x8a0004
#define DUP3_CFASTFINDFILESERVERPLUGIN_DOREQUESTL_EXIT 0x8a0005
#define DUP4_CFASTFINDFILESERVERPLUGIN_DOREQUESTL_EXIT 0x8a0006
#define DUP5_CFASTFINDFILESERVERPLUGIN_DOREQUESTL_EXIT 0x8a0007
#define DUP6_CFASTFINDFILESERVERPLUGIN_DOREQUESTL_EXIT 0x8a0008
#define DUP7_CFASTFINDFILESERVERPLUGIN_DOREQUESTL_EXIT 0x8a0009
#define DUP8_CFASTFINDFILESERVERPLUGIN_DOREQUESTL_EXIT 0x8a000a
#define DUP9_CFASTFINDFILESERVERPLUGIN_DOREQUESTL_EXIT 0x8a000b
#define CFASTFINDFILESERVERPLUGINCONN_DOREQUEST_ENTRY 0x8a000c
#define CFASTFINDFILESERVERPLUGINCONN_DOREQUEST_EXIT 0x8a000d
#define CFASTFINDFILESERVERPLUGIN_REMOVENOTIFICATIONPATH_ENTRY 0x8a000e
#define CFASTFINDFILESERVERPLUGIN_REMOVENOTIFICATIONPATH_EXIT 0x8a000f
#define DUP1_CFASTFINDFILESERVERPLUGIN_REMOVENOTIFICATIONPATH_EXIT 0x8a0010
#define CFASTFINDFILESERVERPLUGIN_ADDIGNOREPATH_ENTRY 0x8a0011
#define CFASTFINDFILESERVERPLUGIN_ADDIGNOREPATH_EXIT 0x8a0012
#define DUP1_CFASTFINDFILESERVERPLUGIN_ADDIGNOREPATH_EXIT 0x8a0013
#define DUP2_CFASTFINDFILESERVERPLUGIN_ADDIGNOREPATH_EXIT 0x8a0014
#define CFASTFINDFILESERVERPLUGIN_REMOVEIGNOREPATH_ENTRY 0x8a0015
#define CFASTFINDFILESERVERPLUGIN_REMOVEIGNOREPATH_EXIT 0x8a0016
#define DUP1_CFASTFINDFILESERVERPLUGIN_REMOVEIGNOREPATH_EXIT 0x8a0017


#ifndef __KERNEL_MODE__
#ifndef __OSTTRACEGEN1_TUINT32_CONST_TDESC16REF__
#define __OSTTRACEGEN1_TUINT32_CONST_TDESC16REF__

inline TBool OstTraceGen1( TUint32 aTraceID, const TDesC16& aParam1 )
    {
    TBool retval;
    TInt size = aParam1.Size();
    // BTrace assumes that parameter size is atleast 4 bytes
    if (size % 4 == 0)
        {
        TUint8* ptr = ( TUint8* )aParam1.Ptr();
        // Data is written directly and length is determined from trace message length
        retval = OstSendNBytes( EXTRACT_GROUP_ID(aTraceID), EOstTrace, KOstTraceComponentID, aTraceID, ptr, size );
        }
    else
        {
        TUint8 data[ KOstMaxDataLength ];
        TUint8* ptr = data;
        if (size > KOstMaxDataLength)
            {
            size = KOstMaxDataLength;
            }
        TInt sizeAligned = ( size + 3 ) & ~3;
        memcpy( ptr, aParam1.Ptr(), size );
        ptr += size;
        // Fillers are written to get 32-bit alignment
        while ( size++ < sizeAligned )
            {
            *ptr++ = 0;
            }
        ptr -= sizeAligned;
        size = sizeAligned;
        // Data is written directly and length is determined from trace message length
        retval = OstSendNBytes( EXTRACT_GROUP_ID(aTraceID), EOstTrace, KOstTraceComponentID, aTraceID, ptr, size );
        }
    return retval;
    }

#endif // __OSTTRACEGEN1_TUINT32_CONST_TDESC16REF__

#endif


#endif

// End of file

