/*
* Copyright (c) 2003 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  The MNssTagSelectHandler interface class handles voice tag select 
*                event, generaed when a voice tag is selected as a result of
*                recognition via MNssRecognitionHandler::SelectTag().
*                To receive the event the client must register via
*                MNssTagSelectNotification::Register().
*				 The client is responsible for deleting the returned voice tag.
*
*/


#ifndef MNSSTAGSELECTHANDLER_H
#define MNSSTAGSELECTHANDLER_H

// INCLUDES

#include "nssvasmtag.h"

// CLASS DEFINITIONS

/**
*  Voice Tag Selection Handler class.
*  Handles the voice tag select notification event generated by
*  MNssRecognitionHandler::SelectTag(). The client is resonsible for deleting the
*  returned voice tag.
*
*  @lib NssVASApi.lib
*  @since 2.0
*/

class MNssTagSelectHandler
{

public:

    /**
    * Handle Tag Select Event - Event indicating a voice tag has been selected.
    * @since 2.0
    * @param aClientTag The voice tag which has been selected. The client is
	*                   resonsible for deleting aClientTag.
    * @return void
    */
	virtual void HandleTagSelect( MNssTag* aClientTag ) = 0;

};

#endif //  MTAGSELECTHANDLER_H

// End of File
