/*
* Copyright (c) 2003 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  The MRejectTagCompleteHandler interface class handles events 
*                generated by RecognizeHandler::RejectTagL().
*
*/


#ifndef MNSSREJECTTAGCOMPLETEHANDLER_H
#define MNSSREJECTTAGCOMPLETEHANDLER_H

//  INCLUDES


// CLASS DECLARATION

/**
*  RejectTag event handler class.
*  Handles events generated by MNssRecognitionHandler::RejectTagL().
*
*  @lib NssVASApi.lib
*  @since 2.0
*/

class MNssRejectTagCompleteHandler
    {

    public:  //enum

	    enum TNssRejectTagError
        {
        EVasErrorNone,
        EVasRejectTagFailed,
		EVasNoTagInContexts,
        EVasRecognizeUndefinedError10,   // for place holder
        EVasRecognizeUndefinedError9,
        EVasRecognizeUndefinedError8,
        EVasRecognizeUndefinedError7,
        EVasRecognizeUndefinedError6,
        EVasRecognizeUndefinedError5,
        EVasRecognizeUndefinedError4,
        EVasRecognizeUndefinedError3,
        EVasRecognizeUndefinedError2,
        EVasRecognizeUndefinedError1
        };
	
    public: // New functions

		/**
		* RejectTag Complete Event -  The requested tags have been rejected, i.e. blacklisted. 
        * @since 2.0
        * @param 
        * @return void
        */      		
		virtual void HandleRejectTagComplete( TNssRejectTagError aErrorCode ) = 0;

		/**
		* RejectTag Error Event - A RejectTag error has occurred  
        * @since 2.0
        * @param aErrorCode The RejectTag error code. 
        * @return void
        */
		//virtual void HandleRejectTagError( TNssRejectTagError aErrorCode ) = 0;

    };

#endif      // MREJECTTAGCOMPLETEHANDLER_H   
            
// End of File
