/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/



#ifndef TERMINALPROFILE_H
#define TERMINALPROFILE_H

#include "terminalprofileconf.h"

/*
    Do not edit this file to change the configuration.

    In Symbian products terminalprofileconf.h shall be handcoded with like this:
    #define TERM_PROFILE_PROFILE_DOWNLOAD   0x01
    #define TERM_PROFILE_SMS_PP_DD          0x02
    #define TERM_PROFILE_CB_DD              0x04
    etc...

*/


            /* First profile byte Download */
const TUint8 TP1 ( (TUint8) (0x00
            | TERM_PROFILE_PROFILE_DOWNLOAD                     /* bit 1 */
            | TERM_PROFILE_SMS_PP_DD                            /* bit 2 */
            | TERM_PROFILE_CB_DD                                /* bit 3 */
            | TERM_PROFILE_MENU_SELECTION                       /* bit 4 */
            | TERM_PROFILE_SMS_PP_DD_9EXX                       /* bit 5 */
            | TERM_PROFILE_TIMER_MANAGEMENT_EXPIRATION          /* bit 6 */
            | TERM_PROFILE_CC_USSD_STRING                       /* bit 7 */
            | TERM_PROFILE_CC_ENVELOPE_DURING_REDIAL            /* bit 8 */
            ) );

            /* Second profile byte Other */
const TUint8 TP2 ( (TUint8) (0x00
            | TERM_PROFILE_COMMAND_RESULT                       /* bit 1 */
            | TERM_PROFILE_CC_BY_SIM                            /* bit 2 */
            | TERM_PROFILE_CC_CELL_ID                           /* bit 3 */
            | TERM_PROFILE_MO_SMS_CONTROL                       /* bit 4 */
            | TERM_PROFILE_CC_ALPHA_ID                          /* bit 5 */
            | TERM_PROFILE_UCS2_ENTRY_SUPP                      /* bit 6 */
            | TERM_PROFILE_UCS2_DISP_SUPP                       /* bit 7 */
            | TERM_PROFILE_DISP_TEXT_EXTENSION                  /* bit 8 */
            ) );

            /* Third profile byte Proactive SIM */
const TUint8 TP3 ( (TUint8) (0x00 \
            | TERM_PROFILE_DISP_TEXT                            /* bit 1 */
            | TERM_PROFILE_GET_INKEY                            /* bit 2 */
            | TERM_PROFILE_GET_INPUT                            /* bit 3 */
            | TERM_PROFILE_MORE_TIME                            /* bit 4 */
            | TERM_PROFILE_PLAY_TONE                            /* bit 5 */
            | TERM_PROFILE_POLL_INTERVAL                        /* bit 6 */
            | TERM_PROFILE_POLLING_OFF                          /* bit 7 */
            | TERM_PROFILE_REFRESH                              /* bit 8 */
            ) );

            /* Fourth profile byte Proactive SIM */
const TUint8 TP4 ( (TUint8) (0x00
            | TERM_PROFILE_SELECT_ITEM                          /* bit 1 */
            | TERM_PROFILE_SEND_SMS                             /* bit 2 */
            | TERM_PROFILE_SEND_SS                              /* bit 3 */
            | TERM_PROFILE_SEND_USSD                            /* bit 4 */
            | TERM_PROFILE_SETUP_CALL                           /* bit 5 */
            | TERM_PROFILE_SETUP_MENU                           /* bit 6 */
            | TERM_PROFILE_PROVIDE_LOCAL_INFO_IMEI              /* bit 7 */
            | TERM_PROFILE_PROVIDE_LOCAL_INFO_NMR               /* bit 8 */
            ) );

            /* Fifth profile byte Event driven information */
const TUint8 TP5 ( (TUint8) (0x00
            | TERM_PROFILE_SET_UP_EVENT_LIST                    /* bit 1 */
            | TERM_PROFILE_MT_CALL                              /* bit 2 */
            | TERM_PROFILE_CALL_CONNECTED                       /* bit 3 */
            | TERM_PROFILE_CALL_DISCONNECTED                    /* bit 4 */
            | TERM_PROFILE_LOCATION_STATUS                      /* bit 5 */
            | TERM_PROFILE_USER_ACTIVITY                        /* bit 6 */
            | TERM_PROFILE_IDLE_SCREEN_AVAIL                    /* bit 7 */
            | TERM_PROFILE_CARD_READER_STATUS                   /* bit 8 */
            ) );

            /* Sixth profile byte Event driven information extensions */
const TUint8 TP6 ( (TUint8) (0x00
            | TERM_PROFILE_LANGUAGE_SELECTION                   /* bit 1 */
            | TERM_PROFILE_BROWSER_TERMINATION                  /* bit 2 */
            | TERM_PROFILE_DATA_AVAILABLE                       /* bit 3 */
            | TERM_PROFILE_CHANNEL_STATUS                       /* bit 4 */
            | TERM_PROFILE_ACCESS_TECHNOLOGY                    /* bit 5 */
            | TERM_PROFILE_DISPLAY_PARAMETERS_CHANGED           /* bit 6 */
            | TERM_PROFILE_LOCAL_CONNECTION                     /* bit 7 */
            | TERM_PROFILE_NETWORK_SEARCH_MODE                  /* bit 8 */
            ) );

            /* Seventh profile byte Multiple card proactive commands */
const TUint8 TP7 ( (TUint8) (0x00
            | TERM_PROFILE_POWER_ON_CARD                        /* bit 1 */
            | TERM_PROFILE_POWER_OFF_CARD                       /* bit 2 */
            | TERM_PROFILE_PERFORM_CARD_APDU                    /* bit 3 */
            | TERM_PROFILE_GET_READER_STATUS                    /* bit 4 */
            | TERM_PROFILE_GET_READER_STATUS_ID                 /* bit 5 */
                                                                /* bit 6-8 RFU */
            ) );

            /* Eighth profile byte Proactive SIM */
const TUint8 TP8 ( (TUint8) (0x00
            | TERM_PROFILE_TIMER_MANAGEMENT_START_STOP          /* bit 1 */
            | TERM_PROFILE_TIMER_MANAGEMENT_GET_VALUE           /* bit 2 */
            | TERM_PROFILE_PROVIDE_LOCAL_INFO_DATE_TIME         /* bit 3 */
            | TERM_PROFILE_GET_INKEY_BINARY                     /* bit 4 */
            | TERM_PROFILE_IDLE_MODE_TEXT                       /* bit 5 */
            | TERM_PROFILE_RUN_AT_COMMAND                       /* bit 6 */
            | TERM_PROFILE_SETUP_CALL_SECOND_ALPHA              /* bit 7 */
            | TERM_PROFILE_CC_SECOND_CCP                        /* bit 8 */
            ) );

            /* Ninth profile byte */
const TUint8 TP9 ( (TUint8) (0x00
            | TERM_PROFILE_SUSTAINED_DISPLAY_TEXT               /* bit 1 */
            | TERM_PROFILE_SEND_DTMF                            /* bit 2 */
            | TERM_PROFILE_PROVIDE_LOCAL_INFO_BCCH              /* bit 3 */
            | TERM_PROFILE_PROVIDE_LOCAL_INFO_LANGUAGE          /* bit 4 */
            | TERM_PROFILE_PROVIDE_LOCAL_INFO_TIMING_ADVANCE    /* bit 5 */
            | TERM_PROFILE_LANGUAGE_NOTIFICATION                /* bit 6 */
            | TERM_PROFILE_LAUNCH_BROWSER                       /* bit 7 */
            | TERM_PROFILE_PROVIDE_LOCAL_INFO_ACCESS_TECHNOLOGY /* bit 8 */
            ) );

            /* Tenth profile byte Soft keys support */
const TUint8 TP10 ( (TUint8) (0x00
            | TERM_PROFILE_SELECT_ITEM_SOFT_KEYS                /* bit 1 */
            | TERM_PROFILE_SETUP_MENU_SOFT_KEYS                 /* bit 2 */
                                                                /* bit 3-8 RFU */
            ) );

            /* Eleventh profile byte Soft keys information */
const TUint8 TP11 ( (TUint8) (0x00
            | TERM_PROFILE_MAX_NO_SOFT_KEYS                     /* bit 1-8 */
            ) );

            /* Twelfth profile byte Bearer independent protocol proactive cmds */
const TUint8 TP12 ( (TUint8) (0x00
            | TERM_PROFILE_OPEN_CHANNEL                         /* bit 1 */
            | TERM_PROFILE_CLOSE_CHANNEL                        /* bit 2 */
            | TERM_PROFILE_RECEIVE_DATA                         /* bit 3 */
            | TERM_PROFILE_SEND_DATA                            /* bit 4 */
            | TERM_PROFILE_GET_CHANNEL_STATUS                   /* bit 5 */
            | TERM_PROFILE_SERVICE_SEARCH                       /* bit 6 */
            | TERM_PROFILE_GET_SERVICE_INFORMAION               /* bit 7 */
            | TERM_PROFILE_DECLARE_SERVICE                      /* bit 8 */
            ) );

            /* Thirteenth profile byte Bearer independent protocol supported bearers */
const TUint8 TP13 ( (TUint8) (0x00
            | TERM_PROFILE_CSD_SUPPORT                          /* bit 1 */
            | TERM_PROFILE_GPRS_SUPPORT                         /* bit 2 */
            | TERM_PROFILE_BLUETOOTH_SUPPORT                    /* bit 3 */
            | TERM_PROFILE_IRDA_SUPPORT                         /* bit 4 */
            | TERM_PROFILE_RS232_SUPPORT                        /* bit 5 */
            | (TERM_PROFILE_NO_CHANNELS << 5)                   /* bit 6-8 */
            ) );

            /* Fourteenth profile byte Screen height */
const TUint8 TP14 ( (TUint8) (0x00
            | TERM_PROFILE_NO_CHARS_DOWN                        /* bit 1-5*/
                                                                /* bit 6-7 rfu */
            | TERM_PROFILE_SCREEN_SIZE_PARAM                    /* bit 8 */
            ) );

            /* Fifteenth profile byte Screen width */
 const TUint8 TP15 ( (TUint8) (0x00
            | TERM_PROFILE_NO_CHARS_ACROSS                      /* bit 1-7 */
            | TERM_PROFILE_VAR_SIZE_FONTS                       /* bit 8 */
            ) );

            /* Sixteenth profile byte Screen effects */
const TUint8 TP16 ( (TUint8) (0x00
            | TERM_PROFILE_DISPLAY_RESIZE                       /* bit 1 */
            | TERM_PROFILE_TEXT_WRAPPING                        /* bit 2 */
            | TERM_PROFILE_TEXT_SCROLLING                       /* bit 3 */
                                                                /* bit 4-5 rfu */
            | (TERM_PROFILE_WIDTH_REDUCTION_IN_MENU << 5)       /* bit 6-8 */
            ) );

           /* Seventeenth profile byte Bearer independent protocol supported transport interface */
 const TUint8 TP17 ( (TUint8) (0x00
            | TERM_PROFILE_TCP                                  /* bit 1 */
            | TERM_PROFILE_UDP                                  /* bit 2 */
                                                                /* bit 3-8 RFU */
            ) );

            /* Eighteenth profile byte for ICC and RUIM */
const TUint8 TP18 ( (TUint8) (0x00
            | TERM_PROFILE_DISPLAY_TXT_TIMEOUT                  /* bit 1 */
            | TERM_PROFILE_GET_INKEY_TIMEOUT_HELP               /* bit 2 */
            | TERM_PROFILE_USB_SUPPORT                          /* bit 3 */
            | TERM_PROFILE_GET_INKEY_TIMEOUT                    /* bit 4 */
                                                                /* bit 5-8 RFU */
            ) );

            /* Eighteenth profile byte for USIM */
const TUint8 TP18_USIM ( (TUint8) (0x00
            | TERM_PROFILE_DISPLAY_TXT_TIMEOUT                  /* bit 1 */
            | TERM_PROFILE_GET_INKEY_TIMEOUT_HELP               /* bit 2 */
            | TERM_PROFILE_USB_SUPPORT                          /* bit 3 */
            | TERM_PROFILE_GET_INKEY_TIMEOUT                    /* bit 4 */
                                                                /* bit 5 RFU*/
            | TERM_PROFILE_CALL_CONTROL_ON_GPRS                 /* bit 6 */
            | TERM_PROFILE_PROVIDE_LOCAL_INFO_IMEISV            /* bit 7 */
            | TERM_PROFILE_PROVIDE_LOCAL_INFO_SEARCH_MODE_CHANGE/* bit 8 */
            ) );

            /* Nineteenth profile byte reserved for TIA/EIA-136 */
const TUint8 TP19 ( (TUint8) (0x00
            | TERM_PROFILE_PROTOCOL_VERSION                     /* bit 1-4 */
                                                                /* bit 5-8 RFU */
            ) );

            /* Twentieth profile byte for ICC and USIM */
const TUint8 TP20 ( (TUint8) (0x00
                                                                /* bit 1-8 RFU */
            ) );

            /* Twenty one profile byte for USIM */
const TUint8 TP21 ( (TUint8) (0x00
            | TERM_PROFILE_WML                                  /* bit 1 */
            | TERM_PROFILE_XHTML                                /* bit 2 */
            | TERM_PROFILE_HTML                                 /* bit 3 */
            | TERM_PROFILE_CHTML                                /* bit 4 */
                                                                /* bit 5-8 RFU */
            ) );

            /* Twenty second profile byte for USIM */
const TUint8 TP22 ( (TUint8) (0x00
             | TERM_PROFILE_UTRAN_PS_EXTENDED                   /* bit 1 */
             | TERM_PROFILE_PROVIDE_LOCAL_INFO_BATTERY_STATE    /* bit 2 */
             | TERM_PROFILE_PLAY_TONE_MELODY_TONES              /* bit 3 */
             | TERM_PROFILE_SETUP_CALL_MULITI_MEDIA             /* bit 4 */
             | TERM_PROFILE_TOOLKIT_GBA                         /* bit 5 */
             | TERM_PROFILE_MULTI_MEDIA_MESSAGE                 /* bit 6 */
             | TERM_PROFILE_SUBMIT_MULTI_MEDIA_MESSAGE          /* bit 7 */
             | TERM_PROFILE_DISPLAY_MULTI_MEDIA_MESSAGE         /* bit 8 */
            ) );

            /* Twenty third profile byte for USIM */
const TUint8 TP23 ( (TUint8) (0x00
             | TERM_PROFILE_SET_FRAMES                          /* bit 1 */
             | TERM_PROFILE_GET_FRAMES_STATUS                   /* bit 2 */
             | TERM_PROFILE_MMS_NOTIFICATION_DOWNLOAD           /* bit 3 */
                                                                /* bit 4-5 RFU */
             | TERM_PROFILE_PROVIDE_LOCAL_INFO_MEID             /* bit 6 */
             | TERM_PROFILE_PROVIDE_LOCAL_INFO_UTRAN_NMR        /* bit 7 */
             | TERM_PROFILE_USSD_DOWNLOAD                       /* bit 8 */
            ) );

const TUint8 KTerminalProfileIcc[19] =
   {
   TP1, TP2, TP3, TP4, TP5, TP6, TP7,
   TP8, TP9, TP10, TP11, TP12, TP13,
   TP14, TP15, TP16, TP17, TP18, TP19
   };

const TUint8 KTerminalProfileUicc[23] =
   {
   TP1, TP2, TP3, TP4, TP5, TP6, TP7, TP8,
   TP9, TP10, TP11, TP12, TP13, TP14, TP15, TP16,
   TP17, TP18_USIM, TP19, TP20, TP21, TP22, TP23
   };

#endif // TERMINALPROFILE_H

// End of File
