/**
* Copyright (c) 2010 Sasken Communication Technologies Ltd.
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the "{License}"
* which accompanies  this distribution, and is available
* at the URL "{LicenseUrl}".
*
* Initial Contributors:
* Chandradeep Gandhi, Sasken Communication Technologies Ltd - Initial contribution
*
* Contributors:
*
* Description:
* Interface spefication for sfm service provider
*
*/

#ifndef SMFPROVIDER_H
#define SMFPROVIDER_H

#include <QObject>
#include <QImage>
#include <QUrl>

#include "../common/SmfClientGlobal.h"
/**
 * Interface for a base service provider. Other service provider classes contains 
 * implementation of this base class so that each has access to service provider 
 * information.
 * All of the functionality described here should be implemented by a service
 * specific plug-in object.
 */
class SMFCLIENT_EXPORT SmfProvider : public QObject
{
  Q_OBJECT

public:
  /**
   *  Seeing as this is a plug-in implementation, these will realistically be generated by SMF factory of some kind
   */
   
  SmfProvider(QObject* parent = 0);
  ~SmfProvider();

public:
  /**
   * Localizable name of the service 
   * @return service name
   */
  virtual QString serviceName() = 0; 
  
  /**
   * Logo of the service
   * @return logo image of the service
   */
  virtual QImage serviceIcon() = 0; // 
  
  /**
   * Readable service description
   * @return service description
   */
  virtual QString description() = 0; // readable service description
  
  /*
   * Website of the service
   */
  virtual QUrl serviceUrl() = 0; //
  
  /**
   * URL of the application providing this service
   */
  virtual QUrl applicationUrl() = 0; //
  
};
/**
* Externalization
*/
QDataStream &operator<<(QDataStream &, const SmfProvider&);
/**
 * Internalization
 */
QDataStream &operator>>(QDataStream &, SmfProvider&);
SMF_GETSERVICES(SmfProvider, "org.symbian.smf.client.provider\0.2")
#endif // SMFPROVIDER_H
